/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import java.io.IOException;
import org.eclipse.jgit.blame.Region;
import org.eclipse.jgit.blame.ReverseWalk;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.treewalk.filter.PathFilter;

class Candidate {
    Candidate queueNext;
    RevCommit sourceCommit;
    PathFilter sourcePath;
    ObjectId sourceBlob;
    RawText sourceText;
    Region regionList;
    int renameScore;

    Candidate(RevCommit commit, PathFilter path) {
        this.sourceCommit = commit;
        this.sourcePath = path;
    }

    int getParentCount() {
        return this.sourceCommit.getParentCount();
    }

    RevCommit getParent(int idx) {
        return this.sourceCommit.getParent(idx);
    }

    Candidate getNextCandidate(int idx) {
        return null;
    }

    void add(RevFlag flag) {
        this.sourceCommit.add(flag);
    }

    int getTime() {
        return this.sourceCommit.getCommitTime();
    }

    PersonIdent getAuthor() {
        return this.sourceCommit.getAuthorIdent();
    }

    Candidate create(RevCommit commit, PathFilter path) {
        return new Candidate(commit, path);
    }

    Candidate copy(RevCommit commit) {
        Candidate r = this.create(commit, this.sourcePath);
        r.sourceBlob = this.sourceBlob;
        r.sourceText = this.sourceText;
        r.regionList = this.regionList;
        r.renameScore = this.renameScore;
        return r;
    }

    void loadText(ObjectReader reader) throws IOException {
        ObjectLoader ldr = reader.open(this.sourceBlob, 3);
        this.sourceText = new RawText(ldr.getCachedBytes(Integer.MAX_VALUE));
    }

    void takeBlame(EditList editList, Candidate child) {
        Candidate.blame(editList, this, child);
    }

    private static void blame(EditList editList, Candidate a, Candidate b) {
        int d;
        Region r = b.clearRegionList();
        Region aTail = null;
        Region bTail = null;
        int eIdx = 0;
        while (eIdx < editList.size()) {
            if (r == null) {
                return;
            }
            Edit e = (Edit)editList.get(eIdx);
            if (e.getEndB() <= r.sourceStart) {
                ++eIdx;
                continue;
            }
            if (r.sourceStart < e.getBeginB()) {
                d = e.getBeginB() - r.sourceStart;
                if (r.length <= d) {
                    Region next = r.next;
                    r.sourceStart = e.getBeginA() - d;
                    aTail = Candidate.add(aTail, a, r);
                    r = next;
                    continue;
                }
                aTail = Candidate.add(aTail, a, r.splitFirst(e.getBeginA() - d, d));
                r.slideAndShrink(d);
            }
            if (e.getLengthB() == 0) {
                ++eIdx;
                continue;
            }
            int rEnd = r.sourceStart + r.length;
            if (rEnd <= e.getEndB()) {
                Region next = r.next;
                bTail = Candidate.add(bTail, b, r);
                r = next;
                if (rEnd != e.getEndB()) continue;
                ++eIdx;
                continue;
            }
            int len = e.getEndB() - r.sourceStart;
            bTail = Candidate.add(bTail, b, r.splitFirst(r.sourceStart, len));
            r.slideAndShrink(len);
            ++eIdx;
        }
        if (r == null) {
            return;
        }
        Edit e = (Edit)editList.get(editList.size() - 1);
        int endB = e.getEndB();
        d = endB - e.getEndA();
        if (aTail == null) {
            a.regionList = r;
        } else {
            aTail.next = r;
        }
        do {
            if (endB > r.sourceStart) continue;
            r.sourceStart -= d;
        } while ((r = r.next) != null);
    }

    private static Region add(Region aTail, Candidate a, Region n) {
        if (aTail == null) {
            a.regionList = n;
            n.next = null;
            return n;
        }
        if (aTail.resultStart + aTail.length == n.resultStart && aTail.sourceStart + aTail.length == n.sourceStart) {
            aTail.length += n.length;
            return aTail;
        }
        aTail.next = n;
        n.next = null;
        return n;
    }

    private Region clearRegionList() {
        Region r = this.regionList;
        this.regionList = null;
        return r;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Candidate[");
        r.append(this.sourcePath.getPath());
        if (this.sourceCommit != null) {
            r.append(" @ ").append(this.sourceCommit.abbreviate(6).name());
        }
        if (this.regionList != null) {
            r.append(" regions:").append(this.regionList);
        }
        r.append("]");
        return r.toString();
    }

    static final class BlobCandidate
    extends Candidate {
        Candidate parent;
        String description;

        BlobCandidate(String name, PathFilter path) {
            super(null, path);
            this.description = name;
        }

        int getParentCount() {
            return this.parent != null ? 1 : 0;
        }

        RevCommit getParent(int idx) {
            return null;
        }

        Candidate getNextCandidate(int idx) {
            return this.parent;
        }

        void add(RevFlag flag) {
        }

        int getTime() {
            return Integer.MAX_VALUE;
        }

        PersonIdent getAuthor() {
            return new PersonIdent(this.description, null);
        }
    }

    static final class ReverseCandidate
    extends Candidate {
        ReverseCandidate(ReverseWalk.ReverseCommit commit, PathFilter path) {
            super(commit, path);
        }

        int getParentCount() {
            return ((ReverseWalk.ReverseCommit)this.sourceCommit).getChildCount();
        }

        RevCommit getParent(int idx) {
            return ((ReverseWalk.ReverseCommit)this.sourceCommit).getChild(idx);
        }

        int getTime() {
            return -this.sourceCommit.getCommitTime();
        }

        Candidate create(RevCommit commit, PathFilter path) {
            return new ReverseCandidate((ReverseWalk.ReverseCommit)commit, path);
        }

        public String toString() {
            return "Reverse" + super.toString();
        }
    }
}

