/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ConsistencyCheckerTest
extends BaseJDBCTestCase {
    private Statement st;
    private ResultSet rs;
    private String[] expColNames;
    private String[][] expRS;
    private final String LANG_INDEX_ROW_COUNT_MISMATCH = "X0Y55";
    private final String LANG_INCONSISTENT_ROW_LOCATION = "X0X62";
    private final String LANG_INDEX_COLUMN_NOT_EQUAL = "X0X61";

    public ConsistencyCheckerTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ConsistencyCheckerTest.class);
    }

    public void testConsistencyChecker() throws Exception {
        this.st = this.createStatement();
        try {
            this.x("create table t1(i int, s smallint, c10 char(10), vc10 varchar(10), dc decimal(5,2))");
            this.x("create index t1_i on t1(i)");
            this.x("create index t1_s on t1(s)");
            this.x("create index t1_c10 on t1(c10)");
            this.x("create index t1_vc10 on t1(vc10)");
            this.x("create index t1_dc on t1(dc)");
            this.x("insert into t1 values (1, 11, '1 1', '1 1 1 ', 111.11)");
            this.x("insert into t1 values (2, 22, '2 2', '2 2 2 ', 222.22)");
            this.x("insert into t1 values (3, 33, '3 3', '3 3 3 ', 333.33)");
            this.x("insert into t1 values (4, 44, '4 4', '4 4 4 ', 444.44)");
            this.q("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.c1();
            this.r1();
            this.x("CREATE PROCEDURE RFHR(P1 VARCHAR(128), P2 VARCHAR(128))LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.reinsertFirstHeapRow'PARAMETER STYLE JAVA");
            this.x("CREATE PROCEDURE DFHR(P1 VARCHAR(128), P2 VARCHAR(128))LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.deleteFirstHeapRow'PARAMETER STYLE JAVA");
            this.x("CREATE PROCEDURE NFHR(P1 VARCHAR(128), P2 VARCHAR(128))LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.nullFirstHeapRow'PARAMETER STYLE JAVA");
            this.setAutoCommit(false);
            CallableStatement callableStatement = this.prepareCall("call RFHR('APP', 'T1')");
            ConsistencyCheckerTest.assertUpdateCount(callableStatement, 0);
            this.e("X0Y55", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_i");
            this.x("create index t1_i on t1(i)");
            this.e("X0Y55", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_s");
            this.x("create index t1_s on t1(s)");
            this.e("X0Y55", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_c10");
            this.x("create index t1_c10 on t1(c10)");
            this.e("X0Y55", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_vc10");
            this.x("create index t1_vc10 on t1(vc10)");
            this.e("X0Y55", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_dc");
            this.x("create index t1_dc on t1(dc)");
            this.q("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.c1();
            this.r1();
            callableStatement = this.prepareCall("call DFHR('APP', 'T1')");
            ConsistencyCheckerTest.assertUpdateCount(callableStatement, 0);
            this.e("X0X62", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_i");
            this.x("create index t1_i on t1(i)");
            this.e("X0X62", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_s");
            this.x("create index t1_s on t1(s)");
            this.e("X0X62", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_c10");
            this.x("create index t1_c10 on t1(c10)");
            this.e("X0X62", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_vc10");
            this.x("create index t1_vc10 on t1(vc10)");
            this.e("X0X62", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_dc");
            this.x("create index t1_dc on t1(dc)");
            this.q("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.c1();
            this.r1();
            this.q("select * from t1");
            this.expColNames = new String[]{"I", "S", "C10", "VC10", "DC"};
            JDBC.assertColumnNames(this.rs, this.expColNames);
            this.expRS = new String[][]{{"2", "22", "2 2", "2 2 2", "222.22"}, {"3", "33", "3 3", "3 3 3", "333.33"}, {"4", "44", "4 4", "4 4 4", "444.44"}, {"1", "11", "1 1", "1 1 1", "111.11"}};
            JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
            callableStatement = this.prepareCall("call NFHR('APP', 'T1')");
            ConsistencyCheckerTest.assertUpdateCount(callableStatement, 0);
            this.q("select * from t1");
            this.expColNames = new String[]{"I", "S", "C10", "VC10", "DC"};
            JDBC.assertColumnNames(this.rs, this.expColNames);
            this.expRS = new String[][]{{null, null, null, null, null}, {"3", "33", "3 3", "3 3 3", "333.33"}, {"4", "44", "4 4", "4 4 4", "444.44"}, {"1", "11", "1 1", "1 1 1", "111.11"}};
            JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
            this.e("X0X61", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_i");
            this.x("create index t1_i on t1(i)");
            this.e("X0X61", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_s");
            this.x("create index t1_s on t1(s)");
            this.e("X0X61", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_c10");
            this.x("create index t1_c10 on t1(c10)");
            this.e("X0X61", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_vc10");
            this.x("create index t1_vc10 on t1(vc10)");
            this.e("X0X61", "values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.x("drop index t1_dc");
            this.x("create index t1_dc on t1(dc)");
            this.q("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T1')");
            this.c1();
            this.r1();
        }
        finally {
            this.dontThrow(this.st, "drop table t1");
            this.commit();
            this.st = null;
            this.rs = null;
            this.expColNames = null;
            this.expRS = null;
        }
    }

    private void x(String string) throws SQLException {
        this.st.executeUpdate(string);
    }

    private void q(String string) throws SQLException {
        this.rs = this.st.executeQuery(string);
    }

    private void c1() throws SQLException {
        this.expColNames = new String[]{"1"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
    }

    private void r1() throws SQLException {
        this.expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
    }

    private void e(String string, String string2) {
        ConsistencyCheckerTest.assertStatementError(string, this.st, string2);
    }

    private void dontThrow(Statement statement, String string) {
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

