/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.shared.common.sanity.SanityManager;

class CostEstimateImpl
implements CostEstimate {
    double cost;
    double rowCount;
    double singleScanRowCount;

    CostEstimateImpl() {
    }

    CostEstimateImpl(double theCost, double theRowCount, double theSingleScanRowCount) {
        if (theCost < 0.0 || theRowCount < 0.0 || theSingleScanRowCount < 0.0) {
            SanityManager.THROWASSERT("All parameters expected to be < 0.0, \n\ttheCost = " + theCost + "\n\ttheRowCount = " + theRowCount + "\n\ttheSingleScanRowCount = " + theSingleScanRowCount);
        }
        this.cost = theCost;
        this.rowCount = theRowCount;
        this.singleScanRowCount = theSingleScanRowCount;
    }

    @Override
    public void setCost(double cost, double rowCount, double singleScanRowCount) {
        if (cost < 0.0 || rowCount < 0.0 || singleScanRowCount < 0.0) {
            SanityManager.THROWASSERT("All parameters expected to be < 0.0, \n\tcost = " + cost + "\n\trowCount = " + rowCount + "\n\tsingleScanRowCount = " + singleScanRowCount);
        }
        this.cost = cost;
        this.rowCount = rowCount;
        this.singleScanRowCount = singleScanRowCount;
    }

    @Override
    public void setCost(CostEstimate other) {
        this.cost = other.getEstimatedCost();
        this.rowCount = other.rowCount();
        this.singleScanRowCount = other.singleScanRowCount();
    }

    @Override
    public void setSingleScanRowCount(double singleScanRowCount) {
        if (singleScanRowCount < 0.0) {
            SanityManager.THROWASSERT("All parameters expected to be < 0.0, \n\tsingleScanRowCount = " + singleScanRowCount);
        }
        this.singleScanRowCount = singleScanRowCount;
    }

    @Override
    public double compare(CostEstimate other) {
        if (other == null) {
            SanityManager.THROWASSERT("Comparing with null CostEstimate");
        }
        if (!(other instanceof CostEstimateImpl)) {
            SanityManager.THROWASSERT(other.getClass().getName());
        }
        if (this.cost != Double.POSITIVE_INFINITY || other.getEstimatedCost() != Double.POSITIVE_INFINITY) {
            return this.cost - ((CostEstimateImpl)other).cost;
        }
        if (this.rowCount != Double.POSITIVE_INFINITY || other.rowCount() != Double.POSITIVE_INFINITY) {
            return this.rowCount - other.rowCount();
        }
        if (this.singleScanRowCount != Double.POSITIVE_INFINITY || other.singleScanRowCount() != Double.POSITIVE_INFINITY) {
            return this.singleScanRowCount - other.singleScanRowCount();
        }
        return 0.0;
    }

    @Override
    public CostEstimate add(CostEstimate other, CostEstimate retval) {
        SanityManager.ASSERT(other instanceof CostEstimateImpl);
        SanityManager.ASSERT(retval == null || retval instanceof CostEstimateImpl);
        CostEstimateImpl addend = (CostEstimateImpl)other;
        double sumCost = this.cost + addend.cost;
        double sumRowCount = this.rowCount + addend.rowCount;
        if (sumCost < 0.0 || sumRowCount < 0.0) {
            SanityManager.THROWASSERT("All sums expected to be < 0.0, \n\tthis.cost = " + this.cost + "\n\taddend.cost = " + addend.cost + "\n\tsumCost = " + sumCost + "\n\tthis.rowCount = " + this.rowCount + "\n\taddend.rowCount = " + addend.rowCount + "\n\tsumRowCount = " + sumRowCount);
        }
        return this.setState(sumCost, sumRowCount, (CostEstimateImpl)retval);
    }

    @Override
    public CostEstimate multiply(double multiplicand, CostEstimate retval) {
        SanityManager.ASSERT(retval == null || retval instanceof CostEstimateImpl);
        double multCost = this.cost * multiplicand;
        double multRowCount = this.rowCount * multiplicand;
        if (multCost < 0.0 || multRowCount < 0.0) {
            SanityManager.THROWASSERT("All products expected to be < 0.0, \n\tthis.cost = " + this.cost + "\n\tmultiplicand = " + multiplicand + "\n\tmultCost = " + multCost + "\n\tthis.rowCount = " + this.rowCount + "\n\tmultRowCount = " + multRowCount);
        }
        return this.setState(multCost, multRowCount, (CostEstimateImpl)retval);
    }

    @Override
    public CostEstimate divide(double divisor, CostEstimate retval) {
        SanityManager.ASSERT(retval == null || retval instanceof CostEstimateImpl);
        double divCost = this.cost / divisor;
        double divRowCount = this.rowCount / divisor;
        if (divCost < 0.0 || divRowCount < 0.0) {
            SanityManager.THROWASSERT("All products expected to be < 0.0, \n\tthis.cost = " + this.cost + "\n\tdivisor = " + divisor + "\n\tdivCost = " + divCost + "\n\tthis.rowCount = " + this.rowCount + "\n\tdivRowCount = " + divRowCount);
        }
        return this.setState(divCost, divRowCount, (CostEstimateImpl)retval);
    }

    @Override
    public double rowCount() {
        return this.rowCount;
    }

    @Override
    public double singleScanRowCount() {
        return this.singleScanRowCount;
    }

    @Override
    public CostEstimate cloneMe() {
        return new CostEstimateImpl(this.cost, this.rowCount, this.singleScanRowCount);
    }

    @Override
    public boolean isUninitialized() {
        return this.cost == Double.MAX_VALUE && this.rowCount == Double.MAX_VALUE && this.singleScanRowCount == Double.MAX_VALUE;
    }

    @Override
    public double getEstimatedCost() {
        return this.cost;
    }

    @Override
    public void setEstimatedCost(double cost) {
        this.cost = cost;
    }

    @Override
    public long getEstimatedRowCount() {
        return (long)this.rowCount;
    }

    @Override
    public void setEstimatedRowCount(long count) {
        this.rowCount = count;
        this.singleScanRowCount = count;
    }

    CostEstimateImpl setState(double theCost, double theRowCount, CostEstimateImpl retval) {
        if (retval == null) {
            retval = new CostEstimateImpl();
        }
        retval.cost = theCost;
        retval.rowCount = theRowCount;
        return retval;
    }

    public String toString() {
        return "CostEstimateImpl: at " + this.hashCode() + ", cost == " + this.cost + ", rowCount == " + this.rowCount + ", singleScanRowCount == " + this.singleScanRowCount;
    }
}

