/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;

public class SelectDistinctTest
extends JDBCPerfTestCase {
    private PreparedStatement ps;
    private static final String TEST_CHAR5 = "selectDistinctChar5";
    private static final int EXPECTED_DISTINCT_CHAR5 = 120;
    private static final String TEST_BINARY5 = "selectDistinctBinary5";
    private static final int EXPECTED_DISTINCT_BINARY5 = 120;

    private SelectDistinctTest(String string, int n, int n2) {
        super(string, n, n2);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SelectDistinctTest");
        baseTestSuite.addTest((Test)new SelectDistinctTest(TEST_CHAR5, 2000, 4));
        baseTestSuite.addTest((Test)new SelectDistinctTest(TEST_BINARY5, 2000, 4));
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("CREATE TABLE selectDistinctChar5(COL CHAR(5))");
                statement.execute("INSERT INTO selectDistinctChar5 SELECT V1.X||V2.X||V3.X||V4.X||V5.X FROM (VALUES 'A', 'B', 'C', 'D', 'E') V1(X), (VALUES 'A', 'B', 'C', 'D', 'E') V2(X), (VALUES 'A', 'B', 'C', 'D', 'E') V3(X), (VALUES 'A', 'B', 'C', 'D', 'E') V4(X), (VALUES 'A', 'B', 'C', 'D', 'E') V5(X) WHERE (SELECT COUNT(*) FROM (VALUES 'A', 'B', 'C', 'D', 'E') VV(X) WHERE VV.X NOT IN (V1.X,V2.X,V3.X,V4.X,V5.X)) = 0");
                for (int i = 0; i < 3; ++i) {
                    statement.execute("INSERT INTO selectDistinctChar5 SELECT * FROM selectDistinctChar5");
                }
                statement.execute("CREATE TABLE selectDistinctBinary5(COL CHAR(5) FOR BIT DATA)");
                statement.execute("CREATE FUNCTION CHAR_TO_BINARY(STR CHAR(5)) RETURNS CHAR(5) FOR BIT DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + SelectDistinctTest.class.getName() + ".charToBinary' NO SQL");
                statement.execute("INSERT INTO selectDistinctBinary5 SELECT CHAR_TO_BINARY(COL) FROM selectDistinctChar5");
            }
        };
    }

    protected void setUp() throws SQLException {
        this.ps = this.prepareStatement("SELECT DISTINCT * FROM " + this.getName());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.ps = null;
    }

    public static byte[] charToBinary(String string) throws UnsupportedEncodingException {
        return string.getBytes("UTF-8");
    }

    public void selectDistinctChar5() throws SQLException {
        JDBC.assertDrainResults(this.ps.executeQuery(), 120);
    }

    public void selectDistinctBinary5() throws SQLException {
        JDBC.assertDrainResults(this.ps.executeQuery(), 120);
    }
}

