/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Timer;
import java.util.TimerTask;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseTestCase;

public final class SpawnedProcess {
    private static final String TAG = "DEBUG: {SpawnedProcess} ";
    private static Timer KILL_TIMER;
    private static final String KILL_THRESHOLD_PROPERTY = "derby.tests.process.killThreshold";
    private static final long KILL_THRESHOLD_DEFAULT = 2700000L;
    private static final long KILL_THRESHOLD;
    private final String name;
    private final Process javaProcess;
    private final StreamSaver errSaver;
    private final StreamSaver outSaver;
    private boolean suppressOutput;
    private final TimerTask killTask;
    int stdOutReadOffset;

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("DEBUG: {SpawnedProcess} Interrupted while sleeping (ignored)");
        }
    }

    public SpawnedProcess(Process process, String string) {
        this.javaProcess = process;
        this.name = string;
        this.errSaver = this.startStreamSaver(process.getErrorStream(), string.concat(":System.err"));
        this.outSaver = this.startStreamSaver(process.getInputStream(), string.concat(":System.out"));
        this.killTask = this.scheduleKill(process, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTask scheduleKill(Process process, String string) {
        Object object = KILL_THRESHOLD_PROPERTY;
        synchronized (KILL_THRESHOLD_PROPERTY) {
            if (KILL_TIMER == null) {
                KILL_TIMER = new Timer(true);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            object = new ProcessKillerTask(process, string);
            KILL_TIMER.schedule((TimerTask)object, KILL_THRESHOLD);
            return object;
        }
    }

    public void suppressOutputOnComplete() {
        this.suppressOutput = true;
    }

    public Process getProcess() {
        return this.javaProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullServerOutput() throws InterruptedException {
        this.outSaver.thread.join();
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            return this.outSaver.stream.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullServerError() throws InterruptedException {
        this.errSaver.thread.join();
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            return this.errSaver.stream.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextServerOutput() {
        byte[] byArray;
        Object object = this;
        synchronized (object) {
            byArray = this.outSaver.stream.toByteArray();
        }
        object = new String(byArray, this.stdOutReadOffset, byArray.length - this.stdOutReadOffset);
        this.stdOutReadOffset = byArray.length;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFailMessage(String string) {
        SpawnedProcess.sleep(500L);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(":Spawned ");
        stringBuffer.append(this.name);
        stringBuffer.append(" exitCode=");
        try {
            stringBuffer.append(this.javaProcess.exitValue());
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            stringBuffer.append("running");
        }
        ByteArrayOutputStream byteArrayOutputStream = this.errSaver.stream;
        ByteArrayOutputStream byteArrayOutputStream2 = this.outSaver.stream;
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            if (byteArrayOutputStream.size() != 0) {
                stringBuffer.append("\nSTDERR:\n");
                stringBuffer.append(byteArrayOutputStream.toString());
            }
            if (byteArrayOutputStream2.size() != 0) {
                stringBuffer.append("\nSTDOUT:\n");
                stringBuffer.append(byteArrayOutputStream2.toString());
            }
        }
        return stringBuffer.toString();
    }

    public int complete() throws IOException {
        return this.complete(Long.MAX_VALUE);
    }

    public int complete(long l) throws IOException {
        long l2 = System.currentTimeMillis();
        Integer n = null;
        while (n == null) {
            try {
                n = this.javaProcess.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (System.currentTimeMillis() - l2 > l) {
                    this.javaProcess.destroy();
                }
                SpawnedProcess.sleep(500L);
            }
        }
        this.killTask.cancel();
        this.joinWith(this.errSaver.thread);
        this.joinWith(this.outSaver.thread);
        this.cleanupProcess();
        this.printDiagnostics(n);
        return n;
    }

    private void cleanupProcess() {
        this.closeStream(this.javaProcess.getOutputStream());
        this.closeStream(this.javaProcess.getErrorStream());
        this.closeStream(this.javaProcess.getInputStream());
        this.javaProcess.destroy();
    }

    private synchronized void printDiagnostics(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = this.errSaver.stream;
        if (!this.suppressOutput && byteArrayOutputStream.size() != 0) {
            System.err.println("START-SPAWNED:" + this.name + " ERROR OUTPUT:");
            byteArrayOutputStream.writeTo(System.err);
            System.err.println("END-SPAWNED  :" + this.name + " ERROR OUTPUT:");
        }
        ByteArrayOutputStream byteArrayOutputStream2 = this.outSaver.stream;
        if (!this.suppressOutput && n != 0 && byteArrayOutputStream2.size() != 0) {
            System.out.println("START-SPAWNED:" + this.name + " STANDARD OUTPUT: exit code=" + n);
            byteArrayOutputStream2.writeTo(System.out);
            System.out.println("END-SPAWNED  :" + this.name + " STANDARD OUTPUT:");
        }
    }

    private void joinWith(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("DEBUG: {SpawnedProcess} Interrupted while joining with thread '" + thread.toString() + "'");
        }
    }

    private void closeStream(Object object) {
        if (object instanceof InputStream) {
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
        } else if (object instanceof OutputStream) {
            try {
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private StreamSaver startStreamSaver(final InputStream inputStream, String string) {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

            @Override
            public void reset() {
                super.reset();
                new Throwable("WWW").printStackTrace(System.out);
            }
        };
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    int n;
                    byte[] byArray = new byte[1024];
                    while ((n = inputStream.read(byArray)) != -1) {
                        SpawnedProcess spawnedProcess = SpawnedProcess.this;
                        synchronized (spawnedProcess) {
                            byteArrayOutputStream.write(byArray, 0, n);
                        }
                    }
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(new PrintStream(byteArrayOutputStream, true));
                }
            }
        }, string);
        thread.setDaemon(true);
        thread.start();
        return new StreamSaver(byteArrayOutputStream, thread);
    }

    public boolean waitForExit(long l, long l2) throws InterruptedException {
        boolean bl = false;
        while (!bl && l > 0L) {
            try {
                this.javaProcess.exitValue();
                bl = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Thread.sleep(l2);
                l -= l2;
            }
        }
        return bl;
    }

    public String jstack() throws InterruptedException, IllegalAccessException, NoSuchFieldException {
        Object object = "";
        if (!BaseTestCase.isWindowsPlatform() && !BaseTestCase.isIBMJVM()) {
            int n = this.getPid();
            String string = BaseTestCase.getJavaExecutableName().replace("jre" + File.separator + "bin" + File.separator + "java", "bin" + File.separator + "jstack");
            String[] stringArray = new String[]{Integer.toString(n)};
            try {
                Process process = BaseTestCase.execJavaCmd(string, null, stringArray, null, false);
                SpawnedProcess spawnedProcess = new SpawnedProcess(process, "jstack");
                spawnedProcess.suppressOutputOnComplete();
                process.getOutputStream().close();
                int n2 = spawnedProcess.complete(30000L);
                Assert.assertTrue((String)spawnedProcess.getFailMessage("jstack failed: "), (n2 == 0 ? 1 : 0) != 0);
                object = spawnedProcess.getFullServerOutput();
            }
            catch (IOException iOException) {
                object = "Tried to catch jstack of hanging subprocess but it failed (using JDK or JRE?): " + iOException;
            }
        }
        return object;
    }

    public int getPid() throws IllegalAccessException, NoSuchFieldException {
        if (!BaseTestCase.isWindowsPlatform() && !BaseTestCase.isIBMJVM()) {
            Field field = this.javaProcess.getClass().getDeclaredField("pid");
            field.setAccessible(true);
            return field.getInt(this.javaProcess);
        }
        return -1;
    }

    static {
        long l = 2700000L;
        String string = BaseTestCase.getSystemProperty(KILL_THRESHOLD_PROPERTY);
        if (string != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("DEBUG: {SpawnedProcess} Invalid kill threshold: " + string);
            }
        }
        KILL_THRESHOLD = l;
    }

    private static class StreamSaver {
        final ByteArrayOutputStream stream;
        final Thread thread;

        StreamSaver(ByteArrayOutputStream byteArrayOutputStream, Thread thread) {
            this.stream = byteArrayOutputStream;
            this.thread = thread;
        }
    }

    private static class ProcessKillerTask
    extends TimerTask {
        private final String name;
        private Process process;

        public ProcessKillerTask(Process process, String string) {
            this.process = process;
            this.name = string;
        }

        @Override
        public synchronized boolean cancel() {
            this.process = null;
            return super.cancel();
        }

        @Override
        public synchronized void run() {
            int n;
            if (this.process == null) {
                return;
            }
            System.err.println("DEBUG: Destroying process '" + this.name + "'");
            this.process.destroy();
            for (n = 10; n > 0; --n) {
                try {
                    int n2 = this.process.exitValue();
                    System.err.println("DEBUG: Destroyed process '" + this.name + "', exit code is " + n2);
                    break;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    SpawnedProcess.sleep(1000L);
                    continue;
                }
            }
            if (n == 0) {
                System.err.println("DEBUG: Failed to destroy process '" + this.name + "'");
            }
            this.process = null;
        }
    }
}

