/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DriverManagerConnector
implements Connector {
    private TestConfiguration config;

    @Override
    public void setConfiguration(TestConfiguration testConfiguration) {
        this.config = testConfiguration;
    }

    @Override
    public Connection openConnection() throws SQLException {
        return this.openConnection(this.config.getDefaultDatabaseName(), this.config.getUserName(), this.config.getUserPassword());
    }

    @Override
    public Connection openConnection(String string) throws SQLException {
        return this.openConnection(string, this.config.getUserName(), this.config.getUserPassword());
    }

    @Override
    public Connection openConnection(String string, String string2) throws SQLException {
        return this.openConnection(this.config.getDefaultDatabaseName(), string, string2);
    }

    @Override
    public Connection openConnection(String string, String string2, String string3) throws SQLException {
        return this.openConnection(string, string2, string3, null);
    }

    @Override
    public Connection openConnection(String string, String string2, String string3, Properties properties) throws SQLException {
        String string4 = this.config.getJDBCUrl(string);
        try {
            DriverManager.getDriver(string4);
        }
        catch (SQLException sQLException) {
            this.loadJDBCDriver();
        }
        Properties properties2 = new Properties(this.config.getConnectionAttributes());
        if (string2 != null) {
            properties2.setProperty("user", string2);
        }
        if (string3 != null) {
            properties2.setProperty("password", string3);
        }
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        try {
            return DriverManager.getConnection(string4, properties2);
        }
        catch (SQLException sQLException) {
            String string5;
            String string6 = string5 = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!string5.equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            Properties properties3 = new Properties(properties2);
            properties3.setProperty("create", "true");
            return DriverManager.getConnection(string4, properties3);
        }
    }

    private static void printFullException(Throwable throwable, int n) {
        if (throwable == null) {
            return;
        }
        String string = "    ";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        stringBuilder.append("Message:  " + throwable.getMessage());
        SQLException sQLException = null;
        if (throwable instanceof SQLException) {
            SQLException sQLException2 = (SQLException)throwable;
            stringBuilder.append(sQLException2.getClass().getName() + " : SQLState = " + sQLException2.getSQLState());
            sQLException = sQLException2.getNextException();
        }
        System.out.println(stringBuilder.toString());
        DriverManagerConnector.printFullException(sQLException, n + 1);
        DriverManagerConnector.printFullException(throwable.getCause(), n + 1);
    }

    @Override
    public void shutDatabase() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("shutdown", "true");
        this.getConnectionByAttributes(this.config.getJDBCUrl(), properties);
        this.config.waitForShutdownComplete(this.getDatabaseName());
    }

    @Override
    public void shutEngine(boolean bl) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("shutdown", "true");
        if (!bl) {
            properties.setProperty("deregister", "false");
        }
        this.getConnectionByAttributes("jdbc:derby:", properties);
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    private Connection getConnectionByAttributes(String string, Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        properties2.setProperty("user", this.config.getUserName());
        properties2.setProperty("password", this.config.getUserPassword());
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            properties2.setProperty(string2, properties.getProperty(string2));
        }
        try {
            DriverManager.getDriver(string);
        }
        catch (SQLException sQLException) {
            this.loadJDBCDriver();
        }
        return DriverManager.getConnection(string, properties2);
    }

    @Override
    public String getDatabaseName() {
        String string = this.config.getDefaultDatabaseName();
        return string;
    }

    private void loadJDBCDriver() throws SQLException {
        String string = this.config.getJDBCClient().getJDBCDriverName();
        try {
            Class<?> clazz = Class.forName(string);
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Failed to load JDBC driver '" + string + "': " + classNotFoundException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException("Failed to load JDBC driver '" + string + "': " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException("Failed to load JDBC driver '" + string + "': " + instantiationException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SQLException("Failed to load JDBC driver '" + string + "': " + noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException("Failed to load JDBC driver '" + string + "': " + invocationTargetException.getMessage());
        }
    }
}

