/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.perf.clients.BackToBackLoadGenerator;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;
import org.apache.derbyTesting.perf.clients.SingleRecordSelectClient;

public class ClobAccessTest
extends JDBCPerfTestCase {
    private static final boolean disableSmallClobs = Boolean.getBoolean("derby.tests.disableSmallClobs");
    private static final boolean disableLargeClobs = Boolean.getBoolean("derby.tests.disableLargeClobs");
    private static final boolean disableConcurrencyTest = Boolean.getBoolean("derby.tests.disableConcurrencyTest");
    private static final String runLargeClobTests = System.getProperty("derby.tests.runLargeClobTests", null);
    private static final int largeClobSizeMB = Integer.getInteger("derby.tests.largeClobSize", 15);
    private static final int MAX_BSIZE = 32676;

    public ClobAccessTest(String string, int n, int n2) {
        super(string, n, n2);
    }

    @Override
    public void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        String[] stringArray;
        int n;
        int n2;
        BaseTestSuite baseTestSuite = new BaseTestSuite("ClobAccessTest suite");
        if (!disableSmallClobs) {
            n2 = 50;
            n = 1;
            ClobAccessTest.println("Adding small Clob tests.");
            stringArray = new BaseTestSuite("Small Clob suite");
            stringArray.addTest((Test)new ClobAccessTest("testFetchSmallClobs", n2, n));
            stringArray.addTest((Test)new ClobAccessTest("testFetchSmallClobsInaccurateLength", n2, n));
            stringArray.addTest((Test)new ClobAccessTest("testModifySmallClobs", n2, n));
            baseTestSuite.addTest((Test)stringArray);
        }
        if (!disableLargeClobs) {
            Object object;
            n2 = 5;
            n = 1;
            stringArray = new String[]{"testFetchLargeClobs", "testFetchLargeClobsModified", "testFetchLargeClobWithStream", "testFetchLargeClobOneByOneCharBaseline", "testFetchLargeClobOneByOneCharModified", "testFetchLargeClobOneByOneChar", "testFetchLargeClobPieceByPiece", "testFetchLargeClobPieceByPieceModified", "testLargeClobGetLength", "testLargeClobGetLengthModified", "testLargeClobTruncateLengthMinusOne", "testFetchLargeClobPieceByPieceBackwards"};
            if (runLargeClobTests != null && ((String[])(object = runLargeClobTests.split(","))).length > 0) {
                stringArray = object;
            }
            ClobAccessTest.println("Adding " + stringArray.length + " large Clob tests.");
            object = new BaseTestSuite("Large Clob suite");
            for (int i = 0; i < stringArray.length; ++i) {
                object.addTest((Test)new ClobAccessTest(stringArray[i], n2, n));
            }
            baseTestSuite.addTest((Test)object);
        }
        if (!disableConcurrencyTest) {
            baseTestSuite.addTest((Test)new ClobAccessTest("testConcurrency", 1, 1));
        }
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                ClobAccessTest.initializeClobData(statement);
            }
        };
    }

    public void testFetchSmallClobs() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from smallClobs");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            String string = clob.getSubString(1L, n);
        }
        resultSet.close();
    }

    public void testFetchSmallClobsInaccurateLength() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from smallClobs");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            String string = clob.getSubString(1L, 100);
        }
        resultSet.close();
    }

    public void testModifySmallClobs() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from smallClobs");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            clob.setString(n, "X");
            String string = clob.getSubString(1L, 100);
        }
        resultSet.close();
    }

    public void testFetchLargeClobs() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs");
        ResultSet resultSet = preparedStatement.executeQuery();
        char[] cArray = new char[16384];
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            Reader reader = clob.getCharacterStream();
            for (long i = (long)resultSet.getInt(2); i > 0L; i -= (long)reader.read(cArray)) {
            }
            reader.close();
        }
        resultSet.close();
    }

    public void testFetchLargeClobsModified() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs");
        ResultSet resultSet = preparedStatement.executeQuery();
        char[] cArray = new char[16384];
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            clob.setString(1L, "X");
            Reader reader = clob.getCharacterStream();
            for (long i = (long)resultSet.getInt(2); i > 0L; i -= (long)reader.read(cArray)) {
            }
            reader.close();
        }
        resultSet.close();
    }

    public void testFetchLargeClobOneByOneCharBaseline() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            Reader reader = clob.getCharacterStream();
            BufferedReader bufferedReader = new BufferedReader(reader);
            long l = resultSet.getInt(2);
            while (bufferedReader.read() != -1) {
                --l;
            }
            reader.close();
            ClobAccessTest.assertEquals((long)0L, (long)l);
        }
        resultSet.close();
    }

    public void testFetchLargeClobOneByOneChar() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            Reader reader = clob.getCharacterStream();
            long l = resultSet.getInt(2);
            while (reader.read() != -1) {
                --l;
            }
            reader.close();
            ClobAccessTest.assertEquals((long)0L, (long)l);
        }
        resultSet.close();
    }

    public void testFetchLargeClobOneByOneCharModified() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            long l = resultSet.getInt(2);
            clob.setString(++l, "X");
            Reader reader = clob.getCharacterStream();
            while (reader.read() != -1) {
                --l;
            }
            reader.close();
            ClobAccessTest.assertEquals((long)0L, (long)l);
        }
        resultSet.close();
    }

    public void testFetchLargeClobPieceByPieceBackwards() throws IOException, SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            if (bl) {
                long l = System.currentTimeMillis();
                clob.setString(++n, "X");
                ClobAccessTest.println("Clob modification duration: " + (System.currentTimeMillis() - l) + " ms");
            }
            long l = n / 2 / 8192 * 8192 - 10;
            for (int i = 0; i < 8192; i += 10) {
                String string = clob.getSubString(l - (long)i, 10);
            }
        }
        resultSet.close();
    }

    public void testFetchLargeClobPieceByPiece() throws IOException, SQLException {
        this.fetchPieceByPiece(false);
    }

    public void testFetchLargeClobPieceByPieceModified() throws IOException, SQLException {
        this.fetchPieceByPiece(true);
    }

    private void fetchPieceByPiece(boolean bl) throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs where id = 4");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            long l;
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(n);
            if (bl) {
                l = System.currentTimeMillis();
                clob.setString(++n, "X");
                ClobAccessTest.println("Clob modification duration: " + (System.currentTimeMillis() - l) + " ms");
            }
            l = 1L;
            while (n > 0) {
                String string = clob.getSubString(l, Math.min(32676, n));
                loopingAlphabetReader.skip(Math.min(32676, n) - 1);
                l += (long)string.length();
                if (bl && (n -= string.length()) == 0) continue;
                ClobAccessTest.assertEquals((int)((Reader)loopingAlphabetReader).read(), (int)string.charAt(string.length() - 1));
            }
        }
        resultSet.close();
    }

    public void testFetchLargeClobWithStream() throws IOException, SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs where id = 5");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(n);
            if (bl) {
                long l = System.currentTimeMillis();
                clob.setString(++n, "X");
                ClobAccessTest.println("Clob modification duration: " + (System.currentTimeMillis() - l) + " ms");
            }
            Reader reader = clob.getCharacterStream();
            char[] cArray = new char[32676];
            while (n > 0) {
                int n2 = reader.read(cArray, 0, Math.min(32676, n));
                loopingAlphabetReader.skip(n2 - 1);
                n -= n2;
                ClobAccessTest.assertEquals((int)((Reader)loopingAlphabetReader).read(), (int)cArray[n2 - 1]);
            }
        }
        resultSet.close();
    }

    public void testLargeClobGetLength() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs where id = 7");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            long l = resultSet.getInt(2);
            for (int i = 0; i < 50; ++i) {
                ClobAccessTest.assertEquals((long)l, (long)clob.length());
            }
        }
        resultSet.close();
    }

    public void testLargeClobGetLengthModified() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs where id = 7");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            clob.setString(1L, "X");
            long l = resultSet.getInt(2);
            for (int i = 0; i < 50; ++i) {
                ClobAccessTest.assertEquals((long)l, (long)clob.length());
            }
        }
        resultSet.close();
    }

    public void testLargeClobTruncateLengthMinusOne() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob, length from largeClobs where id = 8");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Clob clob = resultSet.getClob(1);
            int n = resultSet.getInt(2);
            clob.truncate(n - 1);
        }
    }

    public void testConcurrency() throws InterruptedException, SQLException {
        SingleRecordFiller singleRecordFiller = new SingleRecordFiller(100000, 1, 2005, false, false);
        Connection connection = this.getConnection();
        ClobAccessTest.println("initializing database...");
        singleRecordFiller.fill(connection);
        connection.close();
        Client[] clientArray = new Client[16];
        for (int i = 0; i < clientArray.length; ++i) {
            Connection connection2 = this.openDefaultConnection();
            connection2.setTransactionIsolation(2);
            clientArray[i] = new SingleRecordSelectClient(100000, 1, 2005, false, false);
            clientArray[i].init(connection2);
        }
        BackToBackLoadGenerator backToBackLoadGenerator = new BackToBackLoadGenerator();
        backToBackLoadGenerator.init(clientArray);
        ClobAccessTest.println("starting warmup...");
        backToBackLoadGenerator.startWarmup();
        Thread.sleep(30000L);
        ClobAccessTest.println("entering steady state...");
        backToBackLoadGenerator.startSteadyState();
        Thread.sleep(60000L);
        ClobAccessTest.println("stopping threads...");
        backToBackLoadGenerator.stop();
        backToBackLoadGenerator.printReport(System.out);
    }

    private static void initializeClobData(Statement statement) throws SQLException {
        int n;
        PreparedStatement preparedStatement;
        Connection connection = statement.getConnection();
        connection.setAutoCommit(false);
        if (!disableSmallClobs) {
            ClobAccessTest.println("Generating small Clobs test data.");
            try {
                statement.executeUpdate("drop table smallClobs");
            }
            catch (SQLException sQLException) {
                ClobAccessTest.assertSQLState("42Y55", sQLException);
            }
            statement.executeUpdate("create table smallClobs (dClob clob, length int)");
            preparedStatement = connection.prepareStatement("insert into smallClobs values (?,?)");
            for (n = 1; n < 15001; ++n) {
                String string = Integer.toString(n);
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, string.length());
                preparedStatement.executeUpdate();
                if (n % 1000 != 0) continue;
                connection.commit();
            }
            connection.commit();
        }
        if (!disableLargeClobs) {
            ClobAccessTest.println("Generating large Clobs test data.");
            try {
                statement.executeUpdate("drop table largeClobs");
            }
            catch (SQLException sQLException) {
                ClobAccessTest.assertSQLState("42Y55", sQLException);
            }
            statement.executeUpdate("create table largeClobs (id int unique not null, dClob clob, length int)");
            preparedStatement = connection.prepareStatement("insert into largeClobs values (?,?,?)");
            n = largeClobSizeMB * 1024 * 1024;
            for (int i = 1; i < 11; ++i) {
                preparedStatement.setInt(1, i);
                preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n), n);
                preparedStatement.setInt(3, n);
                preparedStatement.executeUpdate();
                ClobAccessTest.println("Inserted large Clob #" + (i - 1));
            }
            connection.commit();
        }
    }
}

