/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NullsTest
extends BaseJDBCTestCase {
    public NullsTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(NullsTest.class);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testCreate() throws SQLException {
        Statement statement = this.createStatement();
        this.assertCompileError("42X01", "create table a(a1 int null)");
        String string = "create table a(a1 int null not null)";
        NullsTest.assertStatementError("42X01", statement, string);
        string = "create table a(a1 int not null null)";
        NullsTest.assertStatementError("42X01", statement, string);
        string = "create table a1(ac1 int null primary key)";
        NullsTest.assertStatementError("42X01", statement, string);
        string = "create table a1(ac1 int null, ac2 int not null, primary key(ac1,ac2))";
        NullsTest.assertStatementError("42X01", statement, string);
        string = "create table a2(ac1 int null null)";
        NullsTest.assertStatementError("42X01", statement, string);
        string = "create table a3(ac1 int not null null not null)";
        NullsTest.assertStatementError("42X01", statement, string);
        string = "create table a3(ac1 int default null)";
        statement.executeUpdate(string);
        string = "create table a4(ac1 int not null)";
        statement.executeUpdate(string);
        this.dropTable("a3");
        this.dropTable("a4");
        string = "create table a5(ac1 int default null, ac2 int not null)";
        statement.executeUpdate(string);
        this.dropTable("a5");
        string = "create table a6(ac1 int default null)";
        statement.executeUpdate(string);
        string = "create table a7(ac1 int not null primary key)";
        statement.executeUpdate(string);
        this.dropTable("a6");
        this.dropTable("a7");
        statement.close();
    }

    public void testAlter() throws SQLException {
        Statement statement = this.createStatement();
        String string = "create table a(a1 int not null , a2 int not null)";
        statement.executeUpdate(string);
        string = "alter table a add column a3 int null constraint ap1 primary key";
        NullsTest.assertStatementError("42X01", statement, string);
        this.assertCompileError("42X01", "alter table a add column a3 int null");
        string = "alter table a add constraint ap1 primary key(a1,a2)";
        statement.executeUpdate(string);
        this.dropTable("a");
        string = "create table a ( a int not null unique)";
        statement.executeUpdate(string);
        string = "alter table a modify a null";
        NullsTest.assertStatementError("42X01", statement, string);
        this.dropTable("a");
        string = "create table a (a1 int not null, a2 int, a3 int)";
        statement.executeUpdate(string);
        string = "insert into a values(1,1,1)";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "alter table a alter column a2 not null";
        statement.executeUpdate(string);
        string = "alter table a alter column a3 not null";
        statement.executeUpdate(string);
        string = "alter table a add constraint ap1 primary key(a1, a2, a3)";
        statement.executeUpdate(string);
        string = "insert into a values(1, NULL, 1)";
        NullsTest.assertStatementError("23502", statement, string);
        this.dropTable("a");
        string = "create table a (a1 int not null, a2 int default null, a3 int default null)";
        statement.executeUpdate(string);
        string = "insert into a values(1,NULL,1)";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "alter table a add constraint ap1 primary key(a1, a2, a3)";
        NullsTest.assertStatementError("42831", statement, string);
        this.dropTable("a");
        string = "create table a (a1 int not null, a2 int)";
        statement.executeUpdate(string);
        string = "insert into a values(1, NULL)";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "alter table a add constraint ap1 primary key(a1, a2)";
        NullsTest.assertStatementError("42831", statement, string);
        this.dropTable("a");
        string = "create table a (a1 int, a2 int, a3 int)";
        statement.executeUpdate(string);
        string = "alter table a add constraint ap1 primary key(a1, a2, a3)";
        NullsTest.assertStatementError("42831", statement, string);
        this.dropTable("a");
        statement.close();
    }

    public void testInsert() throws SQLException {
        Statement statement = this.createStatement();
        String string = "create table a (a int not null constraint auniq unique)";
        statement.executeUpdate(string);
        string = "insert into a values (1)";
        statement.executeUpdate(string);
        string = "insert into a values (1)";
        NullsTest.assertStatementError("23505", statement, string);
        this.dropTable("a");
        string = "create table s (x int default null not null, y int)";
        statement.executeUpdate(string);
        string = "insert into s (y) values(1)";
        NullsTest.assertStatementError("23502", statement, string);
        string = "select * from s";
        JDBC.assertEmpty(statement.executeQuery(string));
        this.dropTable("s");
        statement.close();
    }

    public void testInsertIntoTableWithNullAndNonNullColumns() throws SQLException {
        Statement statement = this.createStatement();
        String string = "create table t (i int, i_d int default null, i_n int not null, s smallint, s_d smallint default null, s_n smallint not null)";
        statement.executeUpdate(string);
        string = "insert into t (i, i_d, i_n, s, s_d, s_n) values (1, 1, 1, 1, 1, 1)";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "insert into t values (null, null, 2, null, null, 2)";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "insert into t (i, i_n, s, s_d, s_n) values (3, 3, 3, 3, 3)";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "insert into t (i, i_d, i_n, s, s_n) values (4, 4, 4, 4, 4)";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "insert into t (i, i_n, s, s_n) values (5, 5, 5, 5)";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "insert into t (i, i_d, s, s_d) values (6, 6, 6, 6)";
        NullsTest.assertStatementError("23502", statement, string);
        string = "insert into t (i_d, i_n, s_d, s_n) values (7, 7, 7, 7)";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "insert into t values (8, 8, null, 8, 8, 8)";
        NullsTest.assertStatementError("23502", statement, string);
        string = "insert into t values (9, 9, 9, 9, 9, null)";
        NullsTest.assertStatementError("23502", statement, string);
        string = "select * from t";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{"1", "1", "1", "1", "1", "1"}, {null, null, "2", null, null, "2"}, {"3", null, "3", "3", "3", "3"}, {"4", "4", "4", "4", null, "4"}, {"5", null, "5", "5", null, "5"}, {null, "7", "7", null, "7", "7"}});
        this.dropTable("t");
        statement.close();
    }

    public void testISNullAndNot() throws SQLException {
        String string = "create table u (c1 integer)";
        Statement statement = this.createStatement();
        statement.addBatch(string);
        string = "insert into u values null";
        statement.addBatch(string);
        string = "insert into u values 1";
        statement.addBatch(string);
        string = "insert into u values null";
        statement.addBatch(string);
        string = "insert into u values 2";
        statement.addBatch(string);
        statement.executeBatch();
        string = "select * from u";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{null}, {"1"}, {null}, {"2"}});
        string = "select * from u where c1 is null";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{null}, {null}});
        string = "select * from u where c1 is not null";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{"1"}, {"2"}});
        statement.close();
        string = "select * from u where cast (? as varchar(1)) is null";
        PreparedStatement preparedStatement = this.prepareStatement(string);
        preparedStatement.setString(1, "a");
        JDBC.assertEmpty(preparedStatement.executeQuery());
        preparedStatement.close();
        string = "select * from u where cast (? as varchar(1)) is not null";
        PreparedStatement preparedStatement2 = this.prepareStatement(string);
        preparedStatement2.setString(1, "a");
        JDBC.assertFullResultSet(preparedStatement2.executeQuery(), new String[][]{{null}, {"1"}, {null}, {"2"}});
        preparedStatement2.close();
        statement = this.createStatement();
        string = "select count(*) from u where c1 is null";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "2");
        string = "insert into u select * from (values null) as X";
        NullsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "select * from u";
        JDBC.assertFullResultSet(statement.executeQuery(string), new String[][]{{null}, {"1"}, {null}, {"2"}, {null}});
        string = "select count(*) from u where c1 is null";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "3");
        this.dropTable("u");
        statement.close();
    }
}

