/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public class VersionedNetworkServerTestSetup
extends BaseTestSetup {
    private static final DerbyVersion SUPPORTS_NO_SECMAN_ARG = new DerbyVersion(10, 3, 1, 4);
    private static final DerbyVersion NO_BROKEN_SHUTDOWN = new DerbyVersion(10, 4, 0, 0);
    private final DerbyDistribution dist;
    private final String appendToClasspath;
    private SpawnedProcess spawned;
    private NetworkServerControl networkServerControl;

    public VersionedNetworkServerTestSetup(Test test, DerbyDistribution derbyDistribution, String string) {
        super(test);
        this.dist = derbyDistribution;
        this.appendToClasspath = string;
    }

    public void setUp() {
        int n = TestConfiguration.getCurrent().getPort();
        try {
            this.networkServerControl = NetworkServerTestSetup.getNetworkServerControl(n);
        }
        catch (Exception exception) {
            VersionedNetworkServerTestSetup.fail((String)exception.getMessage());
        }
        VersionedNetworkServerTestSetup.println("checking for running server on port " + n);
        if (this.ping(false, null)) {
            VersionedNetworkServerTestSetup.fail((String)("a server is already running at port " + n));
        }
        String string = this.dist.getProductionClasspath() + (String)(this.appendToClasspath == null ? "" : File.pathSeparator + this.appendToClasspath);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("org.apache.derby.drda.NetworkServerControl");
        arrayList.add("start");
        arrayList.add("-p");
        arrayList.add(Integer.toString(n));
        if (this.dist.getVersion().compareTo(SUPPORTS_NO_SECMAN_ARG) >= 0) {
            arrayList.add("-noSecurityManager");
        }
        Process process = null;
        try {
            process = BaseTestCase.execJavaCmd(null, string, arrayList.toArray(new String[arrayList.size()]), null);
        }
        catch (IOException iOException) {
            VersionedNetworkServerTestSetup.fail((String)("failed to start server: " + iOException.getMessage()));
        }
        this.spawned = new SpawnedProcess(process, "NetworkServerControl");
        boolean bl = this.ping(true, process);
        VersionedNetworkServerTestSetup.assertTrue((String)this.spawned.getFailMessage("server failed to come up"), (boolean)bl);
        VersionedNetworkServerTestSetup.println("--- Server " + this.dist.getVersion() + " up");
    }

    public void tearDown() {
        Object object = null;
        boolean bl = false;
        if (this.dist.getVersion().compareTo(NO_BROKEN_SHUTDOWN) < 0) {
            object = this.shutDownInSeparateProcess();
            bl = object != null;
        } else {
            boolean bl2 = this.ping(true, this.spawned.getProcess());
            if (bl2) {
                try {
                    this.networkServerControl.shutdown();
                }
                catch (Exception exception) {
                    String string = this.spawned.getFailMessage("shutdown failed");
                    object = " (failed to shut down server (" + this.dist.getVersion().toString() + "): " + exception.getMessage() + " :: " + string + ")";
                    bl = true;
                }
            }
        }
        try {
            this.spawned.complete(5000L);
        }
        catch (Exception exception) {
            object = "process didn't die: " + exception.getMessage() + (String)(bl ? object : "");
            bl = true;
        }
        this.networkServerControl = null;
        this.spawned = null;
        try {
            BaseTestCase.assertDirectoryDeleted(new File("wombat"));
        }
        catch (AssertionError assertionError) {
            if (bl) {
                object = (String)object + " :: " + ((Throwable)((Object)assertionError)).getMessage();
            }
            throw assertionError;
        }
        if (bl) {
            VersionedNetworkServerTestSetup.fail((String)object);
        }
    }

    private String shutDownInSeparateProcess() {
        Process process;
        int n = TestConfiguration.getCurrent().getPort();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("org.apache.derby.drda.NetworkServerControl");
        arrayList.add("shutdown");
        arrayList.add("-p");
        arrayList.add(Integer.toString(n));
        if (this.dist.getVersion().compareTo(SUPPORTS_NO_SECMAN_ARG) >= 0) {
            arrayList.add("-noSecurityManager");
        }
        try {
            process = BaseTestCase.execJavaCmd(null, this.dist.getProductionClasspath(), arrayList.toArray(new String[arrayList.size()]), null);
        }
        catch (IOException iOException) {
            return "shutdown process failed to start: " + iOException.getMessage();
        }
        SpawnedProcess spawnedProcess = new SpawnedProcess(process, "shutdown process");
        int n2 = -1;
        try {
            n2 = spawnedProcess.complete(10000L);
        }
        catch (IOException iOException) {
            VersionedNetworkServerTestSetup.fail((String)spawnedProcess.getFailMessage("shutdown process failed"));
        }
        if (n2 == 0) {
            return null;
        }
        return spawnedProcess.getFailMessage("abnormal process exit");
    }

    private boolean ping(boolean bl, Process process) {
        boolean bl2 = false;
        try {
            bl2 = NetworkServerTestSetup.pingForServerUp(this.networkServerControl, process, bl);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return bl2;
    }

    private static void println(String string) {
        BaseTestCase.println(string);
    }
}

