/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SequencePermsTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String IRMA = "IRMA";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK", "IRMA"};

    public SequencePermsTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(SequencePermsTest.class);
        CleanDatabaseTestSetup cleanTest = new CleanDatabaseTestSetup((Test)suite);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanTest, LEGAL_USERS, "sequencePermissions");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        return authorizedTest;
    }

    public void test_001_basicGrant() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        Connection frankConnection = this.openUserConnection(FRANK);
        this.goodStatement(ruthConnection, "create sequence seq_01\n");
        this.goodStatement(ruthConnection, "create table t_01( c int )\n");
        this.goodStatement(ruthConnection, "insert into t_01( c ) values ( 1 )\n");
        this.goodStatement(ruthConnection, "create view v_01( a, b ) as select c, next value for seq_01 from t_01\n");
        this.goodStatement(ruthConnection, "grant select on v_01 to alice\n");
        this.expectExecutionError(aliceConnection, "42504", "values ( next value for ruth.seq_01 )\n");
        this.expectExecutionError(aliceConnection, "42502", "select * from ruth.t_01\n");
        this.goodStatement(ruthConnection, "select * from ruth.v_01\n");
        this.goodStatement(ruthConnection, "values ( next value for ruth.seq_01 )\n");
        this.goodStatement(ruthConnection, "grant usage on sequence seq_01 to alice\n");
        this.goodStatement(aliceConnection, "values( next value for ruth.seq_01 )\n");
    }

    public void test_002_basicRevoke() throws Exception {
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection frankConnection = this.openUserConnection(FRANK);
        this.goodStatement(ruthConnection, "create sequence seq_02\n");
        this.goodStatement(frankConnection, "create table t_01( c int )\n");
        this.expectExecutionError(frankConnection, "42504", "values ( next value for ruth.seq_02 )\n");
        this.goodStatement(ruthConnection, "grant usage on sequence seq_02 to public\n");
        this.expectCompilationError(ruthConnection, "42X01", "revoke usage on sequence seq_02 from public\n");
        this.goodStatement(ruthConnection, "revoke usage on sequence seq_02 from public restrict\n");
        String grantUsage = "grant usage on sequence seq_02 to frank\n";
        String revokeUsage = "revoke usage on sequence seq_02 from frank restrict\n";
        String createStatement = "create view v_01( a, b ) as select c, next value for ruth.seq_02 from t_01\n";
        String dropStatement = "drop view v_01\n";
        String badRevokeSQLState = "X0Y23";
        this.verifyRevokePrivilege(ruthConnection, frankConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
        createStatement = "create trigger trig_01 after update on t_01 for each statement insert into t_01( c ) values ( next value for ruth.seq_02 )\n";
        dropStatement = "drop trigger trig_01\n";
        badRevokeSQLState = "X0Y25";
        this.verifyRevokePrivilege(ruthConnection, frankConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
    }

    public void test_003_dropSchema() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection irmaConnection = this.openUserConnection(IRMA);
        this.goodStatement(irmaConnection, "create sequence seq_01\n");
        this.expectExecutionError(dboConnection, "X0Y54", "drop schema irma restrict\n");
        this.goodStatement(irmaConnection, "drop sequence seq_01 restrict\n");
        this.goodStatement(dboConnection, "drop schema irma restrict\n");
    }
}

