/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class JoinResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    public long restrictionTime;
    protected boolean isRightOpen;
    protected ExecRow leftRow;
    protected ExecRow rightRow;
    protected ExecRow mergedRow;
    public NoPutResultSet leftResultSet;
    protected int leftNumCols;
    public NoPutResultSet rightResultSet;
    protected int rightNumCols;
    protected GeneratedMethod restriction;
    public boolean oneRowRightSide;
    public boolean notExistsRightSide;
    String userSuppliedOptimizerOverrides;

    JoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod restriction, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.leftResultSet = leftResultSet;
        this.leftNumCols = leftNumCols;
        this.rightResultSet = rightResultSet;
        this.rightNumCols = rightNumCols;
        this.restriction = restriction;
        this.oneRowRightSide = oneRowRightSide;
        this.notExistsRightSide = notExistsRightSide;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.recordConstructorTime();
    }

    void clearScanState() {
        this.leftRow = null;
        this.rightRow = null;
        this.mergedRow = null;
    }

    @Override
    public void openCore() throws StandardException {
        this.clearScanState();
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "JoinResultSet already open");
        this.leftResultSet.openCore();
        try {
            this.leftRow = this.leftResultSet.getNextRowCore();
            if (this.leftRow != null) {
                this.openRight();
                ++this.rowsSeenLeft;
            }
        }
        catch (StandardException e) {
            this.isOpen = true;
            try {
                this.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw e;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.clearScanState();
        this.leftResultSet.reopenCore();
        this.leftRow = this.leftResultSet.getNextRowCore();
        if (this.leftRow != null) {
            this.openRight();
            ++this.rowsSeenLeft;
        } else if (this.isRightOpen) {
            this.closeRight();
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void close() throws StandardException {
        if (this.isOpen) {
            this.leftResultSet.close();
            if (this.isRightOpen) {
                this.closeRight();
            }
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of JoinResultSet repeated");
        }
        this.clearScanState();
    }

    @Override
    public void finish() throws StandardException {
        this.leftResultSet.finish();
        this.rightResultSet.finish();
        super.finish();
    }

    @Override
    public RowLocation getRowLocation() {
        SanityManager.THROWASSERT("Join used in positioned update/delete");
        return null;
    }

    @Override
    public ExecRow getCurrentRow() {
        SanityManager.THROWASSERT("Join used in positioned update/delete");
        return null;
    }

    protected void openRight() throws StandardException {
        if (this.isRightOpen) {
            this.rightResultSet.reopenCore();
        } else {
            this.rightResultSet.openCore();
            this.isRightOpen = true;
        }
    }

    protected void closeRight() throws StandardException {
        SanityManager.ASSERT(this.isRightOpen, "isRightOpen is expected to be true");
        this.rightResultSet.close();
        this.isRightOpen = false;
    }
}

