/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits$Bits$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits$Bytes$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.parsers.PrimParser;
import passera.unsigned.ULong;
import passera.unsigned.ULong$;
import scala.Int$;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public abstract class BinaryBooleanParserBase
implements ToBriefXMLImpl,
Processor,
PrimProcessor,
Parser,
PrimParser {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(BinaryBooleanParserBase.class.getDeclaredField("parserName$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(BinaryBooleanParserBase.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BinaryBooleanParserBase.class.getDeclaredField("toBits$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private volatile Object parserName$lzy1;
    private final long binaryBooleanTrueRep;
    private final long binaryBooleanFalseRep;
    private final LengthUnits lengthUnits;
    private volatile Object toBits$lzy1;

    public BinaryBooleanParserBase(long binaryBooleanTrueRep, long binaryBooleanFalseRep, LengthUnits lengthUnits) {
        this.binaryBooleanTrueRep = binaryBooleanTrueRep;
        this.binaryBooleanFalseRep = binaryBooleanFalseRep;
        this.lengthUnits = lengthUnits;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
        Parser.$init$(this);
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public String parserName() {
        Object object = this.parserName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.parserName$lzyINIT1();
    }

    private Object parserName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parserName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = Parser.parserName$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parserName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public abstract int getBitLength(PState var1);

    public int toBits() {
        Object object = this.toBits$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.toBits$lzyINIT1());
    }

    private Object toBits$lzyINIT1() {
        Object object;
        block13: {
            while (true) {
                if ((object = this.toBits$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        int n2;
                        LengthUnits lengthUnits = this.lengthUnits;
                        if (LengthUnits$Bits$.MODULE$.equals(lengthUnits)) {
                            n2 = 1;
                        } else if (LengthUnits$Bytes$.MODULE$.equals(lengthUnits)) {
                            n2 = 8;
                        } else {
                            throw this.context().schemaDefinitionError("Binary Numbers must have length units of Bits or Bytes.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                        }
                        n = BoxesRunTime.boxToInteger((int)n2);
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.toBits$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block13;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void parse(PState start) {
        Boolean bl;
        int nBits = this.getBitLength(start);
        if (nBits < 1 || nBits > 32) {
            this.PE(start, "Number of bits %d out of range for xs:boolean, must be between 1 and 32 bits.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nBits)}));
            return;
        }
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.binaryBooleanTrueRep) && !ULong$.MODULE$.$greater$eq$extension(MaybeULong$.MODULE$.getULong$extension(this.binaryBooleanTrueRep), ULong$.MODULE$.apply(0L))) {
            throw Assert$.MODULE$.abort("Invariant broken: BinaryBooleanParserBase.this.binaryBooleanTrueRep.isEmpty.||(BinaryBooleanParserBase.this.binaryBooleanTrueRep.getULong.>=(passera.unsigned.ULong.apply(0L)))");
        }
        if (!ULong$.MODULE$.$greater$eq$extension(this.binaryBooleanFalseRep, ULong$.MODULE$.apply(0L))) {
            throw Assert$.MODULE$.abort("Invariant broken: BinaryBooleanParserBase.this.binaryBooleanFalseRep.>=(passera.unsigned.ULong.apply(0L))");
        }
        InputSourceDataInputStream dis = start.dataInputStream();
        if (!dis.isDefinedForLength(Int$.MODULE$.int2long(nBits))) {
            this.PENotEnoughBits(start, Int$.MODULE$.int2long(nBits), dis);
            return;
        }
        long sl = dis.getUnsignedLong(nBits, start);
        if (!MaybeULong$.MODULE$.isDefined$extension(this.binaryBooleanTrueRep)) {
            bl = this.binaryBooleanFalseRep == sl ? Predef$.MODULE$.boolean2Boolean(false) : Predef$.MODULE$.boolean2Boolean(true);
        } else if (MaybeULong$.MODULE$.getULong$extension(this.binaryBooleanTrueRep) == sl) {
            bl = Predef$.MODULE$.boolean2Boolean(true);
        } else if (this.binaryBooleanFalseRep == sl) {
            bl = Predef$.MODULE$.boolean2Boolean(false);
        } else {
            this.PE(start, "Unable to parse xs:boolean from binary: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new ULong(sl)}));
            return;
        }
        Boolean bool = bl;
        start.simpleElement().overwriteDataValue(DataValue$.MODULE$.toDataValue(bool));
    }
}

