/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.saml;

import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedizSignatureTrustValidator
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(FedizSignatureTrustValidator.class);
    private TrustType signatureTrustType = TrustType.CHAIN_TRUST;
    private Collection<Pattern> subjectDNPatterns = new ArrayList<Pattern>();

    public void setSignatureTrustType(TrustType trustType) {
        this.signatureTrustType = trustType;
    }

    public void setSubjectConstraints(Collection<Pattern> constraints) {
        if (constraints != null) {
            this.subjectDNPatterns.clear();
            this.subjectDNPatterns.addAll(constraints);
        }
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || (credential.getCertificates() == null || credential.getCertificates().length == 0) && credential.getPublicKey() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCredential");
        }
        this.verifyTrust(credential, data);
        return credential;
    }

    protected Credential verifyTrust(Credential credential, RequestData data) throws WSSecurityException {
        X509Certificate[] certs = credential.getCertificates();
        PublicKey publicKey = credential.getPublicKey();
        Crypto crypto = this.getCrypto(data);
        if (crypto == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noSigCryptoFile");
        }
        if (certs != null && certs.length > 0) {
            this.validateCertificates(certs);
            this.verifyTrustInCerts(certs, crypto, data, data.isRevocationEnabled());
            if (this.signatureTrustType.equals((Object)TrustType.CHAIN_TRUST_CONSTRAINTS)) {
                if (this.matches(certs[0])) {
                    return credential;
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
            return credential;
        }
        if (publicKey != null) {
            this.validatePublicKey(publicKey, crypto);
            return credential;
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
    }

    protected Crypto getCrypto(RequestData data) {
        return data.getSigVerCrypto();
    }

    protected void validateCertificates(X509Certificate[] certificates) throws WSSecurityException {
        try {
            for (int i = 0; i < certificates.length; ++i) {
                certificates[i].checkValidity();
            }
        }
        catch (CertificateExpiredException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e, "invalidCert");
        }
        catch (CertificateNotYetValidException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e, "invalidCert");
        }
    }

    protected void verifyTrustInCerts(X509Certificate[] certificates, Crypto crypto, RequestData data, boolean enableRevocation) throws WSSecurityException {
        crypto.verifyTrust(certificates, enableRevocation, null, null);
        String subjectString = certificates[0].getSubjectX500Principal().getName();
        LOG.debug("Certificate path has been verified for certificate with subject {}", (Object)subjectString);
    }

    protected void validatePublicKey(PublicKey publicKey, Crypto crypto) throws WSSecurityException {
        crypto.verifyTrust(publicKey);
    }

    public boolean matches(X509Certificate cert) {
        if (!this.subjectDNPatterns.isEmpty()) {
            if (cert == null) {
                return false;
            }
            String subjectName = cert.getSubjectX500Principal().getName();
            boolean subjectMatch = false;
            for (Pattern subjectDNPattern : this.subjectDNPatterns) {
                Matcher matcher = subjectDNPattern.matcher(subjectName);
                if (!matcher.matches()) continue;
                subjectMatch = true;
                break;
            }
            if (!subjectMatch) {
                return false;
            }
        }
        return true;
    }

    public static enum TrustType {
        CHAIN_TRUST,
        CHAIN_TRUST_CONSTRAINTS,
        PEER_TRUST;

    }
}

