/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import org.tomitribe.auth.signatures.Algorithm;
import org.tomitribe.auth.signatures.Base64;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.Signatures;
import org.tomitribe.auth.signatures.UnsupportedAlgorithmException;

public class Verifier {
    private final Verify verify;
    private final Signature signature;
    private final Algorithm algorithm;
    private final Provider provider;

    public Verifier(Key key, Signature signature) {
        this(key, signature, null);
    }

    public Verifier(Key key, Signature signature, Provider provider) {
        Objects.requireNonNull(key, "Key cannot be null");
        this.signature = Objects.requireNonNull(signature, "Signature cannot be null");
        this.algorithm = signature.getAlgorithm();
        this.provider = provider;
        if (java.security.Signature.class.equals((Object)this.algorithm.getType())) {
            this.verify = new Asymmetric((PublicKey)PublicKey.class.cast(key));
        } else if (Mac.class.equals((Object)this.algorithm.getType())) {
            this.verify = new Symmetric(key);
        } else {
            throw new UnsupportedAlgorithmException(String.format("Unknown Algorithm type %s %s", this.algorithm.getPortableName(), this.algorithm.getType().getName()));
        }
        try {
            this.verify.verify("validation".getBytes());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't initialise the Signer using the provided algorithm and key", e);
        }
    }

    public boolean verify(String method, String uri, Map<String, String> headers) throws IOException, NoSuchAlgorithmException, SignatureException {
        this.signature.verifySignatureValidityDates();
        String signingString = this.createSigningString(method, uri, headers);
        return this.verify.verify(signingString.getBytes());
    }

    public String createSigningString(String method, String uri, Map<String, String> headers) throws IOException {
        return Signatures.createSigningString(this.signature.getHeaders(), method, uri, headers, this.signature.getSignatureCreationTimeMilliseconds(), this.signature.getSignatureExpirationTimeMilliseconds());
    }

    private class Symmetric
    implements Verify {
        private final Key key;

        private Symmetric(Key key) {
            this.key = key;
        }

        @Override
        public boolean verify(byte[] signingStringBytes) {
            try {
                Mac mac = Verifier.this.provider == null ? Mac.getInstance(Verifier.this.algorithm.getJvmName()) : Mac.getInstance(Verifier.this.algorithm.getJvmName(), Verifier.this.provider);
                mac.init(this.key);
                byte[] hash = mac.doFinal(signingStringBytes);
                byte[] encoded = Base64.encodeBase64(hash);
                return MessageDigest.isEqual(encoded, Verifier.this.signature.getSignature().getBytes());
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedAlgorithmException(Verifier.this.algorithm.getJvmName());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class Asymmetric
    implements Verify {
        private final PublicKey key;

        private Asymmetric(PublicKey key) {
            this.key = key;
        }

        @Override
        public boolean verify(byte[] signingStringBytes) {
            try {
                java.security.Signature instance;
                java.security.Signature signature = instance = Verifier.this.provider == null ? java.security.Signature.getInstance(Verifier.this.algorithm.getJvmName()) : java.security.Signature.getInstance(Verifier.this.algorithm.getJvmName(), Verifier.this.provider);
                if (Verifier.this.signature.getParameterSpec() != null) {
                    instance.setParameter(Verifier.this.signature.getParameterSpec());
                }
                instance.initVerify(this.key);
                instance.update(signingStringBytes);
                return instance.verify(Base64.decodeBase64(Verifier.this.signature.getSignature().getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedAlgorithmException(Verifier.this.algorithm.getJvmName());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static interface Verify {
        public boolean verify(byte[] var1);
    }
}

