/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.UUID;

public class ClientMessageImpl
extends CoreMessage
implements ClientMessageInternal {
    public static final SimpleString REPLYTO_HEADER_NAME = MessageUtil.REPLYTO_HEADER_NAME;
    private int deliveryCount;
    private ClientConsumerInternal consumer;
    private int flowControlSize = -1;
    private boolean confirmed;
    private InputStream bodyInputStream;

    public ClientMessageImpl() {
    }

    public ClientMessageImpl(CoreMessageObjectPools coreMessageObjectPools) {
        super(coreMessageObjectPools);
    }

    protected ClientMessageImpl(ClientMessageImpl other) {
        super(other);
    }

    @Override
    public ClientMessageImpl setDurable(boolean durable) {
        super.setDurable(durable);
        return this;
    }

    @Override
    public ClientMessageImpl setExpiration(long expiration) {
        super.setExpiration(expiration);
        return this;
    }

    @Override
    public ClientMessageImpl setPriority(byte priority) {
        super.setPriority(priority);
        return this;
    }

    @Override
    public ClientMessageImpl setUserID(UUID userID) {
        return this;
    }

    public ClientMessageImpl(byte type, boolean durable, long expiration, long timestamp, byte priority, int initialMessageBufferSize, CoreMessageObjectPools coreMessageObjectPools) {
        super(coreMessageObjectPools);
        this.setType(type).setExpiration(expiration).setTimestamp(timestamp).setDurable(durable).setPriority(priority).initBuffer(initialMessageBufferSize);
    }

    public ClientMessageImpl(byte type, boolean durable, long expiration, long timestamp, byte priority, int initialMessageBufferSize) {
        this(type, durable, expiration, timestamp, priority, initialMessageBufferSize, null);
    }

    @Override
    public void onReceipt(ClientConsumerInternal consumer) {
        this.consumer = consumer;
    }

    @Override
    public ClientMessageImpl setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
        return this;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public ClientMessageImpl acknowledge() throws ActiveMQException {
        if (this.consumer != null) {
            this.consumer.acknowledge(this);
        }
        return this;
    }

    @Override
    public ClientMessageImpl individualAcknowledge() throws ActiveMQException {
        if (this.consumer != null) {
            this.consumer.individualAcknowledge(this);
        }
        return this;
    }

    @Override
    public void checkCompletion() throws ActiveMQException {
    }

    @Override
    public int getFlowControlSize() {
        if (this.flowControlSize < 0) {
            throw new IllegalStateException("Flow Control hasn't been set");
        }
        return this.flowControlSize;
    }

    @Override
    public void setFlowControlSize(int flowControlSize) {
        this.flowControlSize = flowControlSize;
    }

    @Override
    public boolean isLargeMessage() {
        return false;
    }

    @Override
    public boolean isCompressed() {
        return this.properties.getBooleanProperty(Message.HDR_LARGE_COMPRESSED);
    }

    @Override
    public int getBodySize() {
        this.checkEncode();
        return this.endOfBodyPosition - 13;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[messageID=" + this.messageID + ", durable=" + this.durable + ", address=" + this.getAddress() + ",userID=" + String.valueOf(Objects.requireNonNullElse(this.getUserID(), "null")) + ", properties=" + this.getProperties().toString() + "]";
    }

    @Override
    public void saveToOutputStream(OutputStream out) throws ActiveMQException {
        try {
            byte[] readBuffer = new byte[this.getBodySize()];
            this.getBodyBuffer().readBytes(readBuffer);
            out.write(readBuffer);
            out.flush();
        }
        catch (IOException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.errorSavingBody(e);
        }
    }

    @Override
    public ClientMessageImpl setOutputStream(OutputStream out) throws ActiveMQException {
        this.saveToOutputStream(out);
        return this;
    }

    @Override
    public boolean waitOutputStreamCompletion(long timeMilliseconds) throws ActiveMQException {
        return true;
    }

    @Override
    public void discardBody() {
    }

    @Override
    public InputStream getBodyInputStream() {
        return this.bodyInputStream;
    }

    @Override
    public ClientMessageImpl setBodyInputStream(InputStream bodyInputStream) {
        this.bodyInputStream = bodyInputStream;
        return this;
    }

    @Override
    public LargeBodyReader getLargeBodyReader() throws ActiveMQException {
        return new DecodingContext();
    }

    @Override
    public ClientMessageImpl putBooleanProperty(SimpleString key, boolean value) {
        return (ClientMessageImpl)super.putBooleanProperty(key, value);
    }

    @Override
    public ClientMessageImpl putByteProperty(SimpleString key, byte value) {
        return (ClientMessageImpl)super.putByteProperty(key, value);
    }

    @Override
    public ClientMessageImpl putBytesProperty(SimpleString key, byte[] value) {
        return (ClientMessageImpl)super.putBytesProperty(key, value);
    }

    @Override
    public ClientMessageImpl putCharProperty(SimpleString key, char value) {
        return (ClientMessageImpl)super.putCharProperty(key, value);
    }

    @Override
    public ClientMessageImpl putCharProperty(String key, char value) {
        return (ClientMessageImpl)super.putCharProperty(key, value);
    }

    @Override
    public ClientMessageImpl putShortProperty(SimpleString key, short value) {
        return (ClientMessageImpl)super.putShortProperty(key, value);
    }

    @Override
    public ClientMessageImpl putIntProperty(SimpleString key, int value) {
        return (ClientMessageImpl)super.putIntProperty(key, value);
    }

    @Override
    public ClientMessageImpl putLongProperty(SimpleString key, long value) {
        return (ClientMessageImpl)super.putLongProperty(key, value);
    }

    @Override
    public ClientMessageImpl putFloatProperty(SimpleString key, float value) {
        return (ClientMessageImpl)super.putFloatProperty(key, value);
    }

    @Override
    public ClientMessageImpl putDoubleProperty(SimpleString key, double value) {
        return (ClientMessageImpl)super.putDoubleProperty(key, value);
    }

    @Override
    public ClientMessageImpl putStringProperty(SimpleString key, SimpleString value) {
        return (ClientMessageImpl)super.putStringProperty(key, value);
    }

    @Override
    public ClientMessageImpl putStringProperty(SimpleString key, String value) {
        return (ClientMessageImpl)super.putStringProperty(key, value);
    }

    @Override
    public ClientMessageImpl putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        return (ClientMessageImpl)super.putObjectProperty(key, value);
    }

    @Override
    public ClientMessageImpl putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        return (ClientMessageImpl)super.putObjectProperty(key, value);
    }

    @Override
    public ClientMessageImpl putBooleanProperty(String key, boolean value) {
        return (ClientMessageImpl)super.putBooleanProperty(key, value);
    }

    @Override
    public ClientMessageImpl putByteProperty(String key, byte value) {
        return (ClientMessageImpl)super.putByteProperty(key, value);
    }

    @Override
    public ClientMessageImpl putBytesProperty(String key, byte[] value) {
        return (ClientMessageImpl)super.putBytesProperty(key, value);
    }

    @Override
    public ClientMessageImpl putShortProperty(String key, short value) {
        return (ClientMessageImpl)super.putShortProperty(key, value);
    }

    @Override
    public ClientMessageImpl putIntProperty(String key, int value) {
        return (ClientMessageImpl)super.putIntProperty(key, value);
    }

    @Override
    public ClientMessageImpl putLongProperty(String key, long value) {
        return (ClientMessageImpl)super.putLongProperty(key, value);
    }

    @Override
    public ClientMessageImpl putFloatProperty(String key, float value) {
        return (ClientMessageImpl)super.putFloatProperty(key, value);
    }

    @Override
    public ClientMessageImpl putDoubleProperty(String key, double value) {
        return (ClientMessageImpl)super.putDoubleProperty(key, value);
    }

    @Override
    public ClientMessageImpl putStringProperty(String key, String value) {
        return (ClientMessageImpl)super.putStringProperty(key, value);
    }

    @Override
    public ClientMessageImpl writeBodyBufferBytes(byte[] bytes) {
        this.getBodyBuffer().writeBytes(bytes);
        return this;
    }

    @Override
    public ClientMessageImpl writeBodyBufferString(String string) {
        this.getBodyBuffer().writeString(string);
        return this;
    }

    @Override
    public Message copy() {
        return new ClientMessageImpl(this);
    }

    @Override
    public boolean isConfirmed() {
        return this.confirmed;
    }

    @Override
    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    private final class DecodingContext
    implements LargeBodyReader {
        private DecodingContext() {
        }

        @Override
        public void open() {
            ClientMessageImpl.this.getBodyBuffer().readerIndex(0);
        }

        @Override
        public void close() {
        }

        @Override
        public long getSize() {
            if (ClientMessageImpl.this.isLargeMessage()) {
                return ClientMessageImpl.this.getBodyBuffer().writerIndex();
            }
            return (long)ClientMessageImpl.this.getBodyBuffer().writerIndex() - 4L;
        }

        @Override
        public void position(long position) {
            ClientMessageImpl.this.buffer.readerIndex((int)position);
        }

        @Override
        public long position() {
            return ClientMessageImpl.this.buffer.readerIndex();
        }

        @Override
        public int readInto(ByteBuffer bufferRead) {
            int remaining = bufferRead.remaining();
            ClientMessageImpl.this.buffer.readBytes(bufferRead);
            return remaining;
        }
    }
}

