/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJoseJwtProducer;

public class JwtRequestCodeGrant
extends AuthorizationCodeGrant {
    private static final long serialVersionUID = -3738825769770411453L;
    private OAuthJoseJwtProducer joseProducer = new OAuthJoseJwtProducer();
    private String clientSecret;
    private String issuer;

    public JwtRequestCodeGrant() {
    }

    public JwtRequestCodeGrant(String issuer) {
        this.issuer = issuer;
    }

    public JwtRequestCodeGrant(String code, String issuer) {
        super(code);
        this.issuer = issuer;
    }

    public JwtRequestCodeGrant(String code, URI uri, String issuer) {
        super(code, uri);
        this.issuer = issuer;
    }

    @Override
    public MultivaluedMap<String, String> toMap() {
        String request = this.getRequest();
        MetadataMap newMap = new MetadataMap();
        newMap.putSingle((Object)"request", (Object)request);
        return newMap;
    }

    public String getRequest() {
        MultivaluedMap<String, String> map = super.toMap();
        JwtClaims claims = new JwtClaims();
        if (this.issuer != null) {
            claims.setIssuer(this.issuer);
        }
        for (String key : map.keySet()) {
            claims.setClaim(key, map.getFirst((Object)key));
        }
        return this.joseProducer.processJwt(new JwtToken(claims), this.clientSecret);
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuthJoseJwtProducer getJoseProducer() {
        return this.joseProducer;
    }

    public void setJoseProducer(OAuthJoseJwtProducer joseProducer) {
        this.joseProducer = joseProducer;
    }
}

