/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.opennlp.maxent;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.model.MaxentModel;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.Classifier_ImplBase;
import org.cleartk.ml.opennlp.maxent.encoder.ContextValues;

public abstract class MaxentClassifier_ImplBase<OUTCOME_TYPE>
extends Classifier_ImplBase<ContextValues, OUTCOME_TYPE, String> {
    protected MaxentModel model;

    public MaxentClassifier_ImplBase(FeaturesEncoder<ContextValues> featuresEncoder, OutcomeEncoder<OUTCOME_TYPE, String> outcomeEncoder, MaxentModel model) {
        super(featuresEncoder, outcomeEncoder);
        this.model = model;
    }

    public OUTCOME_TYPE classify(List<Feature> features) throws CleartkProcessingException {
        ContextValues contextValues = (ContextValues)this.featuresEncoder.encodeAll(features);
        String encodedOutcome = this.model.getBestOutcome(this.model.eval(contextValues.getContext(), contextValues.getValues()));
        return (OUTCOME_TYPE)this.outcomeEncoder.decode((Object)encodedOutcome);
    }

    public Map<OUTCOME_TYPE, Double> score(List<Feature> features) throws CleartkProcessingException {
        ContextValues contextValues = (ContextValues)this.featuresEncoder.encodeAll(features);
        double[] evalResults = this.model.eval(contextValues.getContext(), contextValues.getValues());
        String[] encodedOutcomes = (String[])this.model.getDataStructures()[2];
        HashMap returnValues = Maps.newHashMap();
        for (int i = 0; i < evalResults.length; ++i) {
            returnValues.put(this.outcomeEncoder.decode((Object)encodedOutcomes[i]), evalResults[i]);
        }
        return returnValues;
    }
}

