/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.core.util.collection.HashSetMap;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.consumer.AbstractTermConsumer;
import org.apache.ctakes.dictionary.lookup2.consumer.DefaultTermConsumer;
import org.apache.ctakes.dictionary.lookup2.consumer.TermConsumer;
import org.apache.ctakes.dictionary.lookup2.consumer.UmlsConceptCreator;
import org.apache.ctakes.dictionary.lookup2.textspan.MultiTextSpan;
import org.apache.ctakes.dictionary.lookup2.textspan.TextSpan;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;

public final class PrecisionTermConsumer
extends AbstractTermConsumer {
    private final TermConsumer _idHitConsumer;

    public PrecisionTermConsumer(UimaContext uimaContext, Properties properties) {
        super(uimaContext, properties);
        this._idHitConsumer = new DefaultTermConsumer(uimaContext, properties);
    }

    public PrecisionTermConsumer(UimaContext uimaContext, Properties properties, UmlsConceptCreator umlsConceptCreator) {
        super(uimaContext, properties);
        this._idHitConsumer = new DefaultTermConsumer(uimaContext, properties, umlsConceptCreator);
    }

    @Override
    public void consumeTypeIdHits(JCas jcas, String defaultScheme, int cTakesSemantic, CollectionMap<TextSpan, Long, ? extends Collection<Long>> semanticTerms, CollectionMap<Long, Concept, ? extends Collection<Concept>> conceptMap) throws AnalysisEngineProcessException {
        CollectionMap<TextSpan, Long, ? extends Collection<Long>> preciseTerms = PrecisionTermConsumer.createPreciseTerms(semanticTerms);
        this._idHitConsumer.consumeTypeIdHits(jcas, defaultScheme, cTakesSemantic, preciseTerms, conceptMap);
    }

    public static CollectionMap<TextSpan, Long, ? extends Collection<Long>> createPreciseTerms(CollectionMap<TextSpan, Long, ? extends Collection<Long>> semanticTerms) {
        HashSet<TextSpan> discardSpans = new HashSet<TextSpan>();
        ArrayList textSpans = new ArrayList(semanticTerms.keySet());
        int count = textSpans.size();
        block0: for (int i = 0; i < count; ++i) {
            TextSpan spanKeyI = (TextSpan)textSpans.get(i);
            for (int j = i + 1; j < count; ++j) {
                TextSpan spanKeyJ = (TextSpan)textSpans.get(j);
                if (spanKeyJ.getStart() <= spanKeyI.getStart() && spanKeyJ.getEnd() > spanKeyI.getEnd() || spanKeyJ.getStart() < spanKeyI.getStart() && spanKeyJ.getEnd() >= spanKeyI.getEnd()) {
                    if (spanKeyJ instanceof MultiTextSpan) {
                        boolean spanIok = false;
                        for (TextSpan missingSpanKey : ((MultiTextSpan)spanKeyJ).getMissingSpans()) {
                            if ((missingSpanKey.getStart() < spanKeyI.getStart() || missingSpanKey.getStart() >= spanKeyI.getEnd()) && (missingSpanKey.getEnd() <= spanKeyI.getStart() || missingSpanKey.getEnd() > spanKeyI.getEnd())) continue;
                            spanIok = true;
                            break;
                        }
                        if (!spanIok) {
                            discardSpans.add(spanKeyI);
                            continue block0;
                        }
                    } else {
                        discardSpans.add(spanKeyI);
                        continue block0;
                    }
                }
                if ((spanKeyI.getStart() > spanKeyJ.getStart() || spanKeyI.getEnd() <= spanKeyJ.getEnd()) && (spanKeyI.getStart() >= spanKeyJ.getStart() || spanKeyI.getEnd() < spanKeyJ.getEnd())) continue;
                if (spanKeyI instanceof MultiTextSpan) {
                    boolean spanJok = false;
                    for (TextSpan missingSpanKey : ((MultiTextSpan)spanKeyI).getMissingSpans()) {
                        if ((missingSpanKey.getStart() < spanKeyJ.getStart() || missingSpanKey.getStart() >= spanKeyJ.getEnd()) && (missingSpanKey.getEnd() <= spanKeyJ.getStart() || missingSpanKey.getEnd() > spanKeyJ.getEnd())) continue;
                        spanJok = true;
                        break;
                    }
                    if (spanJok) continue;
                    discardSpans.add(spanKeyJ);
                    continue;
                }
                discardSpans.add(spanKeyJ);
            }
        }
        HashSetMap preciseHitMap = new HashSetMap(textSpans.size() - discardSpans.size());
        for (Map.Entry entry : semanticTerms) {
            if (discardSpans.contains(entry.getKey())) continue;
            preciseHitMap.addAllValues(entry.getKey(), (Collection)entry.getValue());
        }
        return preciseHitMap;
    }
}

