/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.ObjectArrayList;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Arrays;

public class ObjectStack<KType>
extends ObjectArrayList<KType> {
    public ObjectStack() {
    }

    public ObjectStack(int initialCapacity) {
        super(initialCapacity);
    }

    public ObjectStack(int initialCapacity, ArraySizingStrategy resizer) {
        super(initialCapacity, resizer);
    }

    public ObjectStack(ObjectContainer<KType> container) {
        super(container);
    }

    public final void push(KType e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void push(KType e1, KType e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void push(KType e1, KType e2, KType e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public final void push(KType e1, KType e2, KType e3, KType e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public final void push(KType[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(KType ... elements) {
        this.push(elements, 0, elements.length);
    }

    public final int pushAll(ObjectContainer<? extends KType> container) {
        return this.addAll(container);
    }

    public final int pushAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        return this.addAll(iterable);
    }

    public final void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, null);
    }

    public final void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
        this.buffer[this.elementsCount] = null;
    }

    public final KType pop() {
        assert (this.elementsCount > 0);
        Object v = this.buffer[--this.elementsCount];
        this.buffer[this.elementsCount] = null;
        return (KType)v;
    }

    public final KType peek() {
        assert (this.elementsCount > 0);
        return (KType)this.buffer[this.elementsCount - 1];
    }

    public static <KType> ObjectStack<KType> newInstance() {
        return new ObjectStack<KType>();
    }

    public static <KType> ObjectStack<KType> newInstanceWithCapacity(int initialCapacity) {
        return new ObjectStack<KType>(initialCapacity);
    }

    public static <KType> ObjectStack<KType> from(KType ... elements) {
        ObjectStack<KType> stack = new ObjectStack<KType>(elements.length);
        stack.push(elements);
        return stack;
    }

    public static <KType> ObjectStack<KType> from(ObjectContainer<KType> container) {
        return new ObjectStack<KType>(container);
    }

    @Override
    public ObjectStack<KType> clone() {
        return (ObjectStack)super.clone();
    }
}

