/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.utils;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.utils.struct.CounterMap;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;

public class RunCorpusDiagnostics {
    public static void main(String[] args) throws UIMAException, IOException {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles(RunCorpusDiagnostics.getFilesFor(options.getRawTextDirectory(), trainItems));
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(UriToDocumentTextAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(Evaluation_ImplBase.XMIReader.class, (Object[])new Object[]{"XMIDirectory", options.getXMIDirectory()}), new String[0]);
        CounterMap timeClassCounts = new CounterMap();
        JCasIterator casIter = new JCasIterator(reader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jcas = casIter.next();
            JCas goldView = jcas.getView("GoldView");
            Collection rels = JCasUtil.select((JCas)goldView, TemporalTextRelation.class);
            for (BinaryTextRelation rel : rels) {
                Annotation arg1 = rel.getArg1().getArgument();
                Annotation arg2 = rel.getArg2().getArgument();
                String timeClass = null;
                if (arg1 instanceof TimeMention && arg2 instanceof EventMention) {
                    timeClass = ((TimeMention)arg1).getTimeClass();
                } else if (arg1 instanceof EventMention && arg2 instanceof TimeMention) {
                    timeClass = ((TimeMention)arg2).getTimeClass();
                }
                if (timeClass == null) continue;
                timeClassCounts.add((Object)(rel.getCategory() + "--" + timeClass));
            }
        }
        for (String key : timeClassCounts.keySet()) {
            System.out.println(key + " => " + timeClassCounts.get((Object)key));
        }
    }

    private static List<File> getFilesFor(File rawTextDirectory, List<Integer> patientSets) {
        ArrayList<File> files = new ArrayList<File>();
        for (Integer set : patientSets) {
            File setTextDirectory = new File(rawTextDirectory, "doc" + set);
            for (File file : setTextDirectory.listFiles()) {
                if (file.isHidden()) continue;
                files.add(file);
            }
        }
        return files;
    }

    static interface Options {
        @Option(longName={"text"})
        public File getRawTextDirectory();

        @Option(longName={"xmi"})
        public File getXMIDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"treebank"}, defaultToNull=true)
        public File getTreebankDirectory();
    }
}

