/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.pipelines;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import org.apache.ctakes.temporal.ae.BackwardsTimeAnnotator;
import org.apache.ctakes.temporal.ae.DocTimeRelAnnotator;
import org.apache.ctakes.temporal.ae.EventAnnotator;
import org.apache.ctakes.temporal.ae.EventEventRelationAnnotator;
import org.apache.ctakes.temporal.ae.EventTimeRelationAnnotator;
import org.apache.ctakes.temporal.pipelines.TemporalExtractionPipeline_ImplBase;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class FullTemporalExtractionPipeline
extends TemporalExtractionPipeline_ImplBase {
    public static void main(String[] args) throws Exception {
        FullOptions options = (FullOptions)CliFactory.parseArguments(FullOptions.class, (String[])args);
        CollectionReader collectionReader = CollectionReaderFactory.createReaderFromPath((String)"../ctakes-core/desc/collection_reader/FilesInDirectoryCollectionReader.xml", (Object[])new Object[]{"InputDirectory", options.getInputDirectory()});
        AggregateBuilder aggregateBuilder = FullTemporalExtractionPipeline.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(EventAnnotator.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CopyPropertiesToTemporalEventAnnotator.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(DocTimeRelAnnotator.createAnnotatorDescription(options.getDoctimerelModelDirectory() + File.separator + "model.jar"), new String[0]);
        aggregateBuilder.add(BackwardsTimeAnnotator.createAnnotatorDescription(options.getTimeModelDirectory() + File.separator + "model.jar"), new String[0]);
        aggregateBuilder.add(EventTimeRelationAnnotator.createAnnotatorDescription(options.getEventTimeRelationModelDirectory() + File.separator + "model.jar"), new String[0]);
        if (options.getEventEventRelationModelDirectory() != null) {
            aggregateBuilder.add(EventEventRelationAnnotator.createAnnotatorDescription(options.getEventEventRelationModelDirectory() + File.separator + "model.jar"), new String[0]);
        }
        AnalysisEngine xWriter = FullTemporalExtractionPipeline.getXMIWriter(options.getOutputDirectory());
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate(), xWriter});
    }

    public static class CopyPropertiesToTemporalEventAnnotator
    extends JCasAnnotator_ImplBase {
        public void process(JCas jcas) throws AnalysisEngineProcessException {
            for (EventMention mention : JCasUtil.select((JCas)jcas, EventMention.class)) {
                if (!mention.getClass().equals(EventMention.class)) continue;
                EventMention bestCovering = null;
                int smallestSpan = Integer.MAX_VALUE;
                for (EventMention covering : JCasUtil.selectCovering(EventMention.class, (AnnotationFS)mention)) {
                    int span;
                    if (covering.getClass().equals(EventMention.class)) continue;
                    if (covering.getBegin() == mention.getBegin() && covering.getEnd() == mention.getEnd()) {
                        bestCovering = covering;
                        break;
                    }
                    if (covering.getEnd() != mention.getEnd() || (span = covering.getEnd() - covering.getBegin()) >= smallestSpan) continue;
                    span = smallestSpan;
                    bestCovering = covering;
                }
                if (bestCovering == null) continue;
                mention.setPolarity(bestCovering.getPolarity());
                mention.setUncertainty(bestCovering.getUncertainty());
            }
        }
    }

    static interface FullOptions
    extends TemporalExtractionPipeline_ImplBase.Options {
        @Option(shortName={"e"}, description="specify the path to the directory where the trained event model is located", defaultValue={"org/apache/ctakes/temporal/ae/eventannotator/"})
        public String getEventModelDirectory();

        @Option(shortName={"t"}, description="specify the path to the directory where the trained event model is located", defaultValue={"/org/apache/ctakes/temporal/ae/timeannotator/"})
        public String getTimeModelDirectory();

        @Option(shortName={"d"}, description="specify the path to the directory where the trained event-doctime relation model is located", defaultValue={"/org/apache/ctakes/temporal/ae/doctimerel"})
        public String getDoctimerelModelDirectory();

        @Option(shortName={"r"}, description="Specify the path to the directory where the trained event-time relation model is located", defaultValue={"target/eval/thyme/train_and_test/event-time/"})
        public String getEventTimeRelationModelDirectory();

        @Option(shortName={"s"}, description="Specify the path to the directory where the trained event-event relation model is located", defaultValue={"target/eval/thyme/train_and_test/event-event/"})
        public String getEventEventRelationModelDirectory();

        @Option(shortName={"c"}, description="Specify the path to the directory where the trained coreference model is located", defaultToNull=true)
        public String getCoreferenceModelDirectory();
    }
}

