/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.data;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.temporal.nn.data.ArgContextProvider;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class EventEventRelPrinter {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        File trainFile = options.getTrainOutputDirectory();
        if (trainFile.exists()) {
            trainFile.delete();
        }
        trainFile.createNewFile();
        File devFile = options.getTestOutputDirectory();
        if (devFile.exists()) {
            devFile.delete();
        }
        devFile.createNewFile();
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<Integer> devItems = THYMEData.getPatientSets(patientSets, THYMEData.DEV_REMAINDERS);
        List<File> trainFiles = Utils.getFilesFor(trainItems, options.getInputDirectory());
        List<File> devFiles = Utils.getFilesFor(devItems, options.getInputDirectory());
        CollectionReader trainCollectionReader = Utils.getCollectionReader(trainFiles);
        AnalysisEngine trainDataWriter = AnalysisEngineFactory.createEngine(RelationSnippetPrinter.class, (Object[])new Object[]{"IsTraining", true, "OutputFile", trainFile.getAbsoluteFile()});
        SimplePipeline.runPipeline((CollectionReader)trainCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{trainDataWriter});
        CollectionReader devCollectionReader = Utils.getCollectionReader(devFiles);
        AnalysisEngine devDataWriter = AnalysisEngineFactory.createEngine(RelationSnippetPrinter.class, (Object[])new Object[]{"IsTraining", false, "OutputFile", devFile.getAbsolutePath()});
        SimplePipeline.runPipeline((CollectionReader)devCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{devDataWriter});
    }

    public static class RelationSnippetPrinter
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="IsTraining", mandatory=true, description="are we training?")
        private boolean isTraining;
        @ConfigurationParameter(name="OutputFile", mandatory=true, description="path to the output file")
        private String outputFile;
        private Random coin = new Random(0L);

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)goldView, BinaryTextRelation.class)) {
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                relationLookup.put(Arrays.asList(arg1, arg2), relation);
            }
            for (Sentence sentence : JCasUtil.select((JCas)systemView, Sentence.class)) {
                ArrayList<String> eventEventRelationsInSentence = new ArrayList<String>();
                ArrayList eventMentionsInSentence = new ArrayList(JCasUtil.selectCovered((JCas)goldView, EventMention.class, (AnnotationFS)sentence));
                for (int i = 0; i < eventMentionsInSentence.size(); ++i) {
                    for (int j = i + 1; j < eventMentionsInSentence.size(); ++j) {
                        EventMention mention1 = (EventMention)eventMentionsInSentence.get(i);
                        EventMention mention2 = (EventMention)eventMentionsInSentence.get(j);
                        BinaryTextRelation forwardRelation = (BinaryTextRelation)relationLookup.get(Arrays.asList(mention1, mention2));
                        BinaryTextRelation reverseRelation = (BinaryTextRelation)relationLookup.get(Arrays.asList(mention2, mention1));
                        String label = "none";
                        if (forwardRelation != null) {
                            if (forwardRelation.getCategory().equals("CONTAINS")) {
                                label = "contains";
                            }
                        } else if (reverseRelation != null && reverseRelation.getCategory().equals("CONTAINS")) {
                            label = "contains-1";
                        }
                        if (mention1.getBegin() > mention2.getBegin()) {
                            System.out.println("We assumed mention1 is always before mention2");
                            System.out.println(sentence.getCoveredText());
                            System.out.println(mention1.getCoveredText());
                            System.out.println(mention2.getCoveredText());
                            System.out.println();
                        }
                        String context = ArgContextProvider.getTokenContext(systemView, sentence, (Annotation)mention1, "e1", (Annotation)mention2, "e2", 2);
                        String text = String.format("%s|%s", label, context);
                        eventEventRelationsInSentence.add(text.toLowerCase());
                    }
                }
                try {
                    Files.write(Paths.get(this.outputFile, new String[0]), eventEventRelationsInSentence, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"})
        public File getInputDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"output-train"})
        public File getTrainOutputDirectory();

        @Option(longName={"output-test"})
        public File getTestOutputDirectory();
    }
}

