/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import difflib.Chunk;
import difflib.Delta;
import difflib.Patch;
import difflib.myers.Equalizer;
import difflib.myers.MyersDiff;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.tcas.Annotation;

public class CompareFeatureStructures {
    private static final Ordering<FeatureStructure> BY_TYPE_AND_OFFSETS = Ordering.natural().lexicographical().onResultOf(new Function<FeatureStructure, Iterable<Comparable<?>>>(){

        public Iterable<Comparable<?>> apply(@Nullable FeatureStructure input) {
            ArrayList offsets = Lists.newArrayList();
            this.findOffsets(input, offsets);
            ArrayList result = Lists.newArrayList((Object[])new Comparable[]{input.getType().getName()});
            result.addAll(Ordering.natural().sortedCopy((Iterable)offsets));
            return result;
        }

        private void findOffsets(FeatureStructure input, List<Integer> offsets) {
            block8: {
                if (input == null) break block8;
                if (input instanceof Annotation) {
                    Annotation annotation = (Annotation)input;
                    offsets.add(annotation.getBegin());
                    offsets.add(annotation.getEnd());
                } else if (input instanceof FSArray) {
                    FSArray fsArray = (FSArray)input;
                    for (int i = 0; i < fsArray.size(); ++i) {
                        this.findOffsets(fsArray.get(i), offsets);
                    }
                } else if (input instanceof NonEmptyFSList) {
                    NonEmptyFSList fsList = (NonEmptyFSList)input;
                    this.findOffsets((FeatureStructure)fsList.getHead(), offsets);
                    this.findOffsets((FeatureStructure)fsList.getTail(), offsets);
                } else {
                    for (Feature feature : input.getType().getFeatures()) {
                        if (feature.getRange().isPrimitive()) continue;
                        this.findOffsets(input.getFeatureValue(feature), offsets);
                    }
                }
            }
        }
    });

    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        ArrayList annotationClasses = Lists.newArrayList();
        for (String annotationClassName : options.getAnnotationClassNames()) {
            annotationClasses.add(Class.forName(annotationClassName));
        }
        MyersDiff stringDiff = new MyersDiff();
        MyersDiff fsDiff = new MyersDiff((Equalizer)new FeatureStructureEqualizer());
        File originalDir = options.getDirectory1();
        File revisedDir = options.getDirectory2();
        Patch dirPatch = stringDiff.diff((Object[])originalDir.list(), (Object[])revisedDir.list());
        if (!dirPatch.getDeltas().isEmpty()) {
            CompareFeatureStructures.log("--- %s files\n", originalDir);
            CompareFeatureStructures.log("+++ %s files\n", revisedDir);
            CompareFeatureStructures.log(dirPatch);
        } else {
            for (String fileName : originalDir.list()) {
                List<String> revisedViews;
                File originalFile = new File(originalDir, fileName);
                File revisedFile = new File(revisedDir, fileName);
                JCas originalJCas = CompareFeatureStructures.readXMI(originalFile);
                JCas revisedJCas = CompareFeatureStructures.readXMI(revisedFile);
                List<String> originalViews = CompareFeatureStructures.getViewNames(originalJCas);
                Patch viewsPatch = stringDiff.diff(originalViews, revisedViews = CompareFeatureStructures.getViewNames(revisedJCas));
                if (!viewsPatch.getDeltas().isEmpty()) {
                    CompareFeatureStructures.log("--- %s views\n", originalFile);
                    CompareFeatureStructures.log("+++ %s views\n", revisedFile);
                    CompareFeatureStructures.log(viewsPatch);
                    continue;
                }
                for (String viewName : originalViews) {
                    List<FeatureStructure> revisedFSes;
                    JCas originalView = originalJCas.getView(viewName);
                    JCas revisedView = revisedJCas.getView(viewName);
                    List<FeatureStructure> originalFSes = CompareFeatureStructures.toFeatureStructures(originalView, annotationClasses);
                    Patch fsPatch = fsDiff.diff(originalFSes, revisedFSes = CompareFeatureStructures.toFeatureStructures(revisedView, annotationClasses));
                    if (fsPatch.getDeltas().isEmpty()) continue;
                    CompareFeatureStructures.log("--- %s view %s\n", originalFile, viewName);
                    CompareFeatureStructures.log("+++ %s view %s\n", revisedFile, viewName);
                    for (Delta fsDelta : fsPatch.getDeltas()) {
                        CompareFeatureStructures.logHeader(fsDelta);
                        switch (fsDelta.getType()) {
                            case DELETE: 
                            case INSERT: {
                                CompareFeatureStructures.log(fsDelta);
                                break;
                            }
                            case CHANGE: {
                                List<String> originalLines = CompareFeatureStructures.toLines(fsDelta.getOriginal().getLines());
                                List<String> revisedLines = CompareFeatureStructures.toLines(fsDelta.getRevised().getLines());
                                Patch linesPatch = stringDiff.diff(originalLines, revisedLines);
                                ArrayListMultimap deletes = ArrayListMultimap.create();
                                ArrayListMultimap inserts = ArrayListMultimap.create();
                                HashSet skips = Sets.newHashSet();
                                for (Delta linesDelta : linesPatch.getDeltas()) {
                                    Chunk originalChunk = linesDelta.getOriginal();
                                    Chunk revisedChunk = linesDelta.getRevised();
                                    int start = originalChunk.getPosition();
                                    deletes.putAll((Object)start, (Iterable)originalChunk.getLines());
                                    inserts.putAll((Object)start, (Iterable)revisedChunk.getLines());
                                    for (int i = start; i < start + originalChunk.size(); ++i) {
                                        skips.add(i);
                                    }
                                }
                                for (int i = 0; i < originalLines.size(); ++i) {
                                    if (!skips.contains(i)) {
                                        CompareFeatureStructures.log(" %s\n", originalLines.get(i));
                                    }
                                    for (String line : deletes.get((Object)i)) {
                                        CompareFeatureStructures.log("-%s\n", line);
                                    }
                                    for (String line : inserts.get((Object)i)) {
                                        CompareFeatureStructures.log("+%s\n", line);
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }
    }

    private static <T> void log(String message, Object ... args) {
        System.err.printf(message, args);
    }

    private static <T> void log(Patch<T> patch) {
        for (Delta delta : patch.getDeltas()) {
            CompareFeatureStructures.logHeader(delta);
            CompareFeatureStructures.log(delta);
        }
    }

    private static <T> void logHeader(Delta<T> delta) {
        Chunk original = delta.getOriginal();
        Chunk revised = delta.getRevised();
        CompareFeatureStructures.log("@@ -%d,%d +%d,%d @@\n", original.getPosition(), original.size(), revised.getPosition(), revised.size());
    }

    private static <T> void log(Delta<T> delta) {
        Chunk original = delta.getOriginal();
        Chunk revised = delta.getRevised();
        for (Object line : original.getLines()) {
            CompareFeatureStructures.log("-%s\n", line.toString().replaceAll("\n", "\n-"));
        }
        for (Object line : revised.getLines()) {
            CompareFeatureStructures.log("+%s\n", line.toString().replaceAll("\n", "\n+"));
        }
    }

    private static JCas readXMI(File xmiFile) throws Exception {
        JCas jCas = JCasFactory.createJCas();
        try (FileInputStream inputStream = new FileInputStream(xmiFile);){
            XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
        }
        return jCas;
    }

    private static List<String> getViewNames(JCas jCas) throws CASException {
        ArrayList viewNames = Lists.newArrayList();
        Iterator viewIter = jCas.getViewIterator();
        while (viewIter.hasNext()) {
            viewNames.add(((JCas)viewIter.next()).getViewName());
        }
        return viewNames;
    }

    private static List<FeatureStructure> toFeatureStructures(JCas jCas, List<Class<?>> annotationClasses) {
        ArrayList fsList = Lists.newArrayList();
        for (Class<?> annotationClass : annotationClasses) {
            Type type = JCasUtil.getType((JCas)jCas, annotationClass);
            Iterators.addAll((Collection)fsList, (Iterator)jCas.getFSIndexRepository().getAllIndexedFS(type));
        }
        return BY_TYPE_AND_OFFSETS.sortedCopy((Iterable)fsList);
    }

    public static List<String> toLines(List<FeatureStructure> fsList) {
        ArrayList lines = Lists.newArrayList();
        for (FeatureStructure fs : fsList) {
            for (String line : fs.toString().split("\n")) {
                lines.add(line);
            }
        }
        return lines;
    }

    static class FeatureStructureEqualizer
    implements Equalizer<FeatureStructure> {
        FeatureStructureEqualizer() {
        }

        public boolean equals(FeatureStructure original, FeatureStructure revised) {
            return this.equals(original, revised, Lists.newArrayList());
        }

        private boolean equals(FeatureStructure original, FeatureStructure revised, List<FeatureStructure> seen) {
            if (!seen.contains(original) && !seen.contains(revised)) {
                seen.add(original);
                seen.add(revised);
                for (Feature feature : original.getType().getFeatures()) {
                    String revisedValue;
                    String originalValue;
                    if (feature.getName().equals("uima.cas.AnnotationBase:sofa")) continue;
                    if (feature.getRange().isPrimitive()) {
                        originalValue = original.getFeatureValueAsString(feature);
                        if (Objects.equal((Object)originalValue, (Object)(revisedValue = revised.getFeatureValueAsString(feature)))) continue;
                        return false;
                    }
                    originalValue = original.getFeatureValue(feature);
                    revisedValue = revised.getFeatureValue(feature);
                    if (!(originalValue == null || revisedValue == null || !originalValue.getType().getName().equals(revisedValue.getType().getName()) ? !Objects.equal((Object)originalValue, (Object)revisedValue) : !this.equals((FeatureStructure)originalValue, (FeatureStructure)revisedValue, seen))) continue;
                    return false;
                }
            }
            return true;
        }
    }

    static interface Options {
        @Option(longName={"dir1"})
        public File getDirectory1();

        @Option(longName={"dir2"})
        public File getDirectory2();

        @Option(longName={"roots"}, defaultValue={"org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation", "org.apache.ctakes.typesystem.type.relation.Relation"})
        public List<String> getAnnotationClassNames();
    }
}

