/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature.selection;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.transform.TrainableExtractor_ImplBase;
import org.cleartk.ml.feature.transform.TransformableFeature;

public abstract class FeatureSelection<OUTCOME_T>
extends TrainableExtractor_ImplBase<OUTCOME_T>
implements Predicate<Feature> {
    protected boolean isTrained = false;
    protected Set<String> selectedFeatureNames;

    public FeatureSelection(String name) {
        super(name);
    }

    public boolean apply(Feature feature) {
        return this.selectedFeatureNames.contains(this.getFeatureName(feature));
    }

    public Instance<OUTCOME_T> transform(Instance<OUTCOME_T> instance) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Feature feature : instance.getFeatures()) {
            if (this.isTransformable(feature)) {
                features.addAll(Collections2.filter((Collection)((TransformableFeature)feature).getFeatures(), (Predicate)this));
                continue;
            }
            features.add(feature);
        }
        return new Instance(instance.getOutcome(), features);
    }

    public List<Feature> transform(List<Feature> features) {
        ArrayList results = Lists.newArrayList();
        if (this.isTrained) {
            results.addAll(Collections2.filter(features, (Predicate)this));
        } else {
            results.add(new TransformableFeature(this.name, features));
        }
        return results;
    }

    protected String getFeatureName(Feature feature) {
        String featureName = feature.getName();
        Object featureValue = feature.getValue();
        return featureValue instanceof Number ? featureName : featureName + ":" + featureValue;
    }
}

