/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature.duration;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class DurationExpectationFeatureExtractor
implements FeatureExtractor1 {
    public List<Feature> extract(JCas view, Annotation annotation) throws CleartkExtractorException {
        String eventText;
        ArrayList<Feature> features = new ArrayList<Feature>();
        File durationLookup = new File("/Users/dima/Boston/Thyme/Duration/Data/Combined/Distribution/all.txt");
        try {
            eventText = Utils.normalizeEventText(view, annotation);
        }
        catch (AnalysisEngineProcessException e1) {
            e1.printStackTrace();
            return features;
        }
        Map textToDistribution = null;
        try {
            textToDistribution = (Map)Files.readLines((File)durationLookup, (Charset)Charsets.UTF_8, (LineProcessor)new Utils.Callback());
        }
        catch (IOException e) {
            e.printStackTrace();
            return features;
        }
        Map eventDistribution = (Map)textToDistribution.get(eventText);
        if (eventDistribution == null) {
            features.add(new Feature((Object)"no_duration_info"));
            return features;
        }
        float expectation = Utils.expectedDuration(eventDistribution);
        features.add(new Feature("expected_duration", (Object)Float.valueOf(expectation)));
        for (String bin : Utils.bins) {
            features.add(new Feature(bin, eventDistribution.get(bin)));
        }
        String largestBin = null;
        float largestValue = 0.0f;
        for (String bin : Utils.bins) {
            if (!(((Float)eventDistribution.get(bin)).floatValue() > largestValue)) continue;
            largestBin = bin;
            largestValue = ((Float)eventDistribution.get(bin)).floatValue();
        }
        features.add(new Feature((Object)("largest_bin_" + largestBin)));
        return features;
    }
}

