/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.utils.struct.CounterMap;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class UmlsFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        String featName;
        CounterMap<String> typeCounts;
        ArrayList<Feature> features = new ArrayList<Feature>();
        JCas systemView = jCas;
        ArrayList arg1Types = Lists.newArrayList();
        ArrayList arg2Types = Lists.newArrayList();
        if (arg1 instanceof EventMention) {
            typeCounts = UmlsFeatureExtractor.getMentionTypes(JCasUtil.selectCovering((JCas)systemView, EventMention.class, (int)arg1.getBegin(), (int)arg1.getEnd()));
            for (String typeId : typeCounts.keySet()) {
                featName = "arg1EntityTypeID_" + typeId;
                arg1Types.add(featName);
                features.add(new Feature(featName, (Object)typeCounts.get((Object)typeId)));
            }
        }
        if (arg2 instanceof EventMention) {
            typeCounts = UmlsFeatureExtractor.getMentionTypes(JCasUtil.selectCovering((JCas)systemView, EventMention.class, (int)arg2.getBegin(), (int)arg2.getEnd()));
            for (String typeId : typeCounts.keySet()) {
                featName = "arg2EntityTypeID_" + typeId;
                arg2Types.add(featName);
                features.add(new Feature(featName, (Object)typeCounts.get((Object)typeId)));
            }
        }
        if (arg1Types.size() == 0) {
            arg1Types.add("arg1NotUMLS");
        }
        if (arg2Types.size() == 0) {
            arg2Types.add("arg2NotUMLS");
        }
        for (String arg1Type : arg1Types) {
            for (String arg2Type : arg2Types) {
                features.add(new Feature((Object)("ArgPair-" + arg1Type + "_" + arg2Type)));
            }
        }
        return features;
    }

    private static CounterMap<String> getMentionTypes(List<EventMention> entities) {
        CounterMap typeCounts = new CounterMap();
        for (EventMention entityMention : entities) {
            if (entityMention.getDiscoveryTechnique() != 1) continue;
            typeCounts.add((Object)String.valueOf(entityMention.getTypeID()));
        }
        return typeCounts;
    }
}

