/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class TokenPropertyFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        String arg2last;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        List arg1Tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)arg1);
        List arg2Tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)arg2);
        int arg1Length = arg1Tokens == null ? 0 : arg1Tokens.size();
        int arg2Length = arg2Tokens == null ? 0 : arg2Tokens.size();
        feats.add(new Feature("arg1_tokenSize", (Object)arg1Length));
        feats.add(new Feature("arg2_tokenSize", (Object)arg2Length));
        for (BaseToken bt : arg1Tokens) {
            if (!bt.getPartOfSpeech().startsWith("VB")) continue;
            feats.add(new Feature("arg1_contains", (Object)"VB"));
            break;
        }
        for (BaseToken bt : arg2Tokens) {
            if (!bt.getPartOfSpeech().startsWith("VB")) continue;
            feats.add(new Feature("arg2_contains", (Object)"VB"));
            break;
        }
        if (arg1Length == 0 || arg2Length == 0) {
            return feats;
        }
        String arg1last = ((BaseToken)arg1Tokens.get(arg1Length - 1)).getCoveredText().toLowerCase();
        if (arg1last.equals(arg2last = ((BaseToken)arg2Tokens.get(arg2Length - 1)).getCoveredText().toLowerCase())) {
            feats.add(new Feature("contain_matching_last_token", (Object)true));
            feats.add(new Feature("matching_last_token_", (Object)arg1last));
        }
        List arg1anaSites = JCasUtil.selectCovered((JCas)jCas, AnatomicalSiteMention.class, (AnnotationFS)arg1);
        List arg2anaSites = JCasUtil.selectCovered((JCas)jCas, AnatomicalSiteMention.class, (AnnotationFS)arg2);
        for (AnatomicalSiteMention siteA : arg1anaSites) {
            for (AnatomicalSiteMention siteB : arg2anaSites) {
                if (!siteA.getCoveredText().equalsIgnoreCase(siteB.getCoveredText())) continue;
                feats.add(new Feature("contain_matching_anatomicalSite", (Object)true));
                feats.add(new Feature("matching_anatomicalSite_", (Object)siteA.getCoveredText().toLowerCase()));
            }
        }
        List arg1procedure = JCasUtil.selectCovered((JCas)jCas, ProcedureMention.class, (AnnotationFS)arg1);
        List arg2procedure = JCasUtil.selectCovered((JCas)jCas, ProcedureMention.class, (AnnotationFS)arg2);
        for (ProcedureMention proA : arg1procedure) {
            for (ProcedureMention proB : arg2procedure) {
                if (!proA.getCoveredText().equalsIgnoreCase(proB.getCoveredText())) continue;
                feats.add(new Feature("contain_matching_Procedure", (Object)true));
                feats.add(new Feature("matching_Procedure_", (Object)proA.getCoveredText().toLowerCase()));
            }
        }
        List arg1ss = JCasUtil.selectCovered((JCas)jCas, SignSymptomMention.class, (AnnotationFS)arg1);
        List arg2ss = JCasUtil.selectCovered((JCas)jCas, SignSymptomMention.class, (AnnotationFS)arg2);
        for (SignSymptomMention ssA : arg1ss) {
            for (SignSymptomMention ssB : arg2ss) {
                if (!ssA.getCoveredText().equalsIgnoreCase(ssB.getCoveredText())) continue;
                feats.add(new Feature("contain_matching_SignSymptom", (Object)true));
                feats.add(new Feature("matching_SignSymptom_", (Object)ssA.getCoveredText().toLowerCase()));
            }
        }
        List arg1dd = JCasUtil.selectCovered((JCas)jCas, DiseaseDisorderMention.class, (AnnotationFS)arg1);
        List arg2dd = JCasUtil.selectCovered((JCas)jCas, DiseaseDisorderMention.class, (AnnotationFS)arg2);
        for (DiseaseDisorderMention ddA : arg1dd) {
            for (DiseaseDisorderMention ddB : arg2dd) {
                if (!ddA.getCoveredText().equalsIgnoreCase(ddB.getCoveredText())) continue;
                feats.add(new Feature("contain_matching_DiseaseDisorder", (Object)true));
                feats.add(new Feature("matching_DiseaseDisorder_", (Object)ddA.getCoveredText().toLowerCase()));
            }
        }
        List arg1med = JCasUtil.selectCovered((JCas)jCas, MedicationMention.class, (AnnotationFS)arg1);
        List arg2med = JCasUtil.selectCovered((JCas)jCas, MedicationMention.class, (AnnotationFS)arg2);
        for (MedicationMention medA : arg1med) {
            for (MedicationMention medB : arg2med) {
                if (!medA.getCoveredText().equalsIgnoreCase(medB.getCoveredText())) continue;
                feats.add(new Feature("contain_matching_Medication", (Object)true));
                feats.add(new Feature("matching_Medication_", (Object)medA.getCoveredText().toLowerCase()));
            }
        }
        return feats;
    }
}

