/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class NearbyVerbTenseXExtractor
implements FeatureExtractor1 {
    private String name = "VerbTenseFeature";

    public List<Feature> extract(JCas view, Annotation annotation) throws CleartkExtractorException {
        EventMention targetTokenAnnotation;
        ArrayList<Feature> features = new ArrayList<Feature>();
        Map coveringMap = JCasUtil.indexCovering((JCas)view, EventMention.class, Sentence.class);
        Collection sentList = (Collection)coveringMap.get(targetTokenAnnotation = (EventMention)annotation);
        if (sentList != null && !sentList.isEmpty()) {
            for (Sentence sent : sentList) {
                String verbTP = "";
                for (WordToken wt : JCasUtil.selectCovered((JCas)view, WordToken.class, (AnnotationFS)sent)) {
                    String pos;
                    if (wt == null || !(pos = wt.getPartOfSpeech()).startsWith("VB")) continue;
                    verbTP = verbTP + "_" + pos;
                }
                Feature feature = new Feature(this.name, (Object)verbTP);
                features.add(feature);
            }
        }
        return features;
    }
}

