/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class EventPropertyExtractor
implements FeatureExtractor1<Annotation> {
    private static Integer polarity;
    private static final List<String> genericWords;

    public List<Feature> extract(JCas view, Annotation annotation) throws CleartkExtractorException {
        String fname;
        ArrayList<Feature> features = new ArrayList<Feature>();
        try {
            String docID = DocumentIDAnnotationUtil.getDocumentID((JCas)view);
            int begin = docID.lastIndexOf("_");
            fname = docID.substring(begin + 1);
            features.add(new Feature("docName", (Object)fname));
            if (fname.equals("RAD") || fname.equals("SP")) {
                features.add(new Feature((Object)"docName:RAD+SP"));
            } else {
                features.add(new Feature((Object)"docName:others"));
            }
        }
        catch (CASRuntimeException e) {
            e.printStackTrace();
            fname = "CASRuntimeException.UnableToGetDocIdFromUriView";
            features.add(new Feature("docName", (Object)fname));
        }
        EventMention event = (EventMention)annotation;
        HashSet coveringSents = new HashSet();
        coveringSents.addAll(JCasUtil.selectCovering((JCas)view, Sentence.class, (int)event.getBegin(), (int)event.getEnd()));
        for (Sentence coveringSent : coveringSents) {
            ArrayList<EventMention> events = JCasUtil.selectCovered(EventMention.class, (AnnotationFS)coveringSent);
            ArrayList<EventMention> realEvents = new ArrayList<EventMention>();
            for (EventMention eventa : events) {
                if (!eventa.getClass().equals(EventMention.class)) continue;
                realEvents.add(eventa);
            }
            events = realEvents;
            if (events.size() > 0) {
                EventMention anchor = (EventMention)events.get(0);
                EventMention end = (EventMention)events.get(events.size() - 1);
                if (event == anchor) {
                    features.add(new Feature((Object)"LeftMostEvent"));
                } else if (event == end) {
                    features.add(new Feature((Object)"RightMostEvent"));
                }
            }
            ArrayList words = new ArrayList(JCasUtil.selectPreceding((JCas)view, WordToken.class, (AnnotationFS)event, (int)15));
            words.addAll(JCasUtil.selectFollowing((JCas)view, WordToken.class, (AnnotationFS)event, (int)15));
            for (WordToken word : words) {
                if (EventPropertyExtractor.outsideScope(word, coveringSent) || !genericWords.contains(word.getCoveredText().toLowerCase())) continue;
                features.add(new Feature((Object)"GenericEvent"));
                break;
            }
            int newlineNum = 0;
            for (BaseToken btoken : JCasUtil.selectPreceding((JCas)view, BaseToken.class, (AnnotationFS)event, (int)20)) {
                if (!(btoken instanceof NewlineToken)) continue;
                ++newlineNum;
            }
            if (newlineNum > 0) {
                features.add(new Feature((Object)"hasPrecedingNewline"));
                features.add(new Feature("newLineNum_preceding", (Object)newlineNum));
            }
            newlineNum = 0;
            for (BaseToken btoken : JCasUtil.selectFollowing((JCas)view, BaseToken.class, (AnnotationFS)event, (int)20)) {
                if (!(btoken instanceof NewlineToken)) continue;
                ++newlineNum;
            }
            if (newlineNum <= 0) continue;
            features.add(new Feature((Object)"hasFollowingNewline"));
            features.add(new Feature("newLineNum_following", (Object)newlineNum));
        }
        features.addAll(EventPropertyExtractor.getEventFeats("mentionProperty", event));
        return features;
    }

    private static boolean outsideScope(WordToken word, Sentence eventSent) {
        if (word.getBegin() < eventSent.getBegin()) {
            return true;
        }
        return word.getEnd() > eventSent.getEnd();
    }

    private static Collection<? extends Feature> getEventFeats(String name, EventMention mention) {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        if (mention.getEvent() == null || mention.getEvent().getProperties() == null) {
            return feats;
        }
        String contextualModality = mention.getEvent().getProperties().getContextualModality();
        if (contextualModality != null) {
            feats.add(new Feature(name + "_modality", (Object)contextualModality));
        }
        if ((polarity = Integer.valueOf(mention.getEvent().getProperties().getPolarity())) != null) {
            feats.add(new Feature(name + "_polarity", (Object)polarity));
        }
        return feats;
    }

    static {
        genericWords = new ArrayList<String>();
        genericWords.add("potential");
        genericWords.add("possible");
        genericWords.add("may");
        genericWords.add("likely");
        genericWords.add("probable");
        genericWords.add("prospective");
        genericWords.add("instruct");
        genericWords.add("if");
        genericWords.add("could");
        genericWords.add("discussed");
        genericWords.add("discussion");
        genericWords.add("considered");
        genericWords.add("monitor");
        genericWords.add("plan");
        genericWords.add("cxr");
        genericWords.add("data");
    }
}

