/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class CoveredTextToValuesExtractor
implements FeatureExtractor1 {
    private String name;
    private Map<String, double[]> textDoublesMap;
    private double[] meanValues;

    public static Map<String, double[]> parseTextDoublesMap(File file, Charset charset) throws IOException {
        return (Map)Files.readLines((File)file, (Charset)charset, (LineProcessor)new StringToDoublesProcessor());
    }

    public CoveredTextToValuesExtractor(String name, Map<String, double[]> textDoublesMap) {
        this.name = name;
        this.textDoublesMap = textDoublesMap;
        int nMapEntries = this.textDoublesMap.size();
        if (nMapEntries == 0) {
            throw new IllegalArgumentException("textDoublesMap cannot be empty");
        }
        int nValues = textDoublesMap.entrySet().iterator().next().getValue().length;
        this.meanValues = new double[nValues];
        for (double[] values : textDoublesMap.values()) {
            for (int i = 0; i < values.length; ++i) {
                int n = i;
                this.meanValues[n] = this.meanValues[n] + values[i];
            }
        }
        int i = 0;
        while (i < this.meanValues.length) {
            int n = i++;
            this.meanValues[n] = this.meanValues[n] / (double)nMapEntries;
        }
    }

    public List<Feature> extract(JCas view, Annotation annotation) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (annotation instanceof WordToken) {
            double[] values = this.textDoublesMap.get(annotation.getCoveredText().toLowerCase());
            if (values == null) {
                values = this.meanValues;
            }
            for (int i = 0; i < values.length; ++i) {
                String featureName = Feature.createName((String[])new String[]{this.name, String.valueOf(i)});
                features.add(new Feature(featureName, (Object)values[i]));
            }
        }
        return features;
    }

    static class StringToDoublesProcessor
    implements LineProcessor<Map<String, double[]>> {
        private Logger logger = Logger.getLogger(this.getClass().getName());
        private Map<String, double[]> result = new HashMap<String, double[]>();
        private int length = -1;

        StringToDoublesProcessor() {
        }

        public Map<String, double[]> getResult() {
            return this.result;
        }

        public boolean processLine(String line) throws IOException {
            String[] parts = line.trim().split(",");
            String key = parts[0];
            int partsOffset = 0;
            if (this.length == -1) {
                this.length = parts.length;
            } else if (parts.length != this.length) {
                String message = "expected %d parts, found %d, skipping line '%s'";
                this.logger.warning(String.format(message, this.length, parts.length, line));
                return true;
            }
            double[] values = new double[parts.length - 1];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Double.parseDouble(parts[i + 1 + partsOffset]);
            }
            this.result.put(key, values);
            return true;
        }
    }
}

