/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class WithinSentenceBeforeRelationAnnotator
extends JCasAnnotator_ImplBase {
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashMap<Object, Object> timeNorm = new HashMap<Object, Object>();
        TimeMention docTime = null;
        for (Object timex : JCasUtil.select((JCas)jCas, TimeMention.class)) {
            if (!timex.getTimeClass().equals("DOCTIME")) continue;
            docTime = timex;
            break;
        }
        if (docTime != null) {
            for (Object timex : JCasUtil.select((JCas)jCas, TimeMention.class)) {
                String value;
                if (timex.getTimeClass().equals("DOCTIME") || (value = Utils.getTimexMLValue(timex.getCoveredText(), docTime.getCoveredText())) == null) continue;
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    Date parsedDate = dateFormat.parse(value);
                    Timestamp timestamp = new Timestamp(parsedDate.getTime());
                    timeNorm.put(timex, timestamp);
                }
                catch (Exception e) {
                    System.out.println("cannot parse timex :" + value);
                }
            }
        }
        HashSet<TimeMention> relationalTimex = new HashSet<TimeMention>();
        for (Object relarg : JCasUtil.select((JCas)jCas, RelationArgument.class)) {
            Annotation arg = relarg.getArgument();
            if (!(arg instanceof TimeMention)) continue;
            relationalTimex.add((TimeMention)arg);
        }
        relationalTimex.retainAll(timeNorm.keySet());
        HashMap timeEvents = new HashMap();
        for (TimeMention time : relationalTimex) {
            HashSet<EventMention> containedEvents = new HashSet<EventMention>();
            for (TemporalTextRelation rel : JCasUtil.select((JCas)jCas, TemporalTextRelation.class)) {
                if (rel.getCategory().equals("CONTAINS")) {
                    if (rel.getArg1().getArgument() != time) continue;
                    containedEvents.add((EventMention)rel.getArg2().getArgument());
                    continue;
                }
                if (!rel.getCategory().equals("CONTAINS-1") || rel.getArg2().getArgument() != time) continue;
                containedEvents.add((EventMention)rel.getArg1().getArgument());
            }
            timeEvents.put(time, containedEvents);
        }
        int timexNum = relationalTimex.size();
        ArrayList timexLst = new ArrayList(relationalTimex);
        for (int i = 0; i < timexNum - 1; ++i) {
            TimeMention timeA = (TimeMention)timexLst.get(i);
            for (int j = i + 1; j < timexNum; ++j) {
                Object eventB3;
                Timestamp stampB;
                TimeMention timeB = (TimeMention)timexLst.get(j);
                if (timeA == timeB || !JCasUtil.selectBetween((JCas)jCas, NewlineToken.class, (AnnotationFS)timeA, (AnnotationFS)timeB).isEmpty()) continue;
                Timestamp stampA = (Timestamp)timeNorm.get(timeA);
                int compareResult = stampA.compareTo(stampB = (Timestamp)timeNorm.get(timeB));
                if (compareResult < 0) {
                    for (EventMention eventA : (Set)timeEvents.get(timeA)) {
                        for (EventMention eventB2 : (Set)timeEvents.get(timeB)) {
                            if (eventA == eventB2) continue;
                            this.createRelation(jCas, (IdentifiedAnnotation)eventA, (IdentifiedAnnotation)eventB2, "BEFORE", 1.0);
                        }
                    }
                    continue;
                }
                if (compareResult > 0) {
                    for (Object eventB3 : (Set)timeEvents.get(timeB)) {
                        for (EventMention eventA : (Set)timeEvents.get(timeA)) {
                            if (eventA == eventB3) continue;
                            this.createRelation(jCas, (IdentifiedAnnotation)eventB3, (IdentifiedAnnotation)eventA, "BEFORE", 1.0);
                        }
                    }
                    continue;
                }
                HashSet groupA = new HashSet();
                groupA.addAll((Collection)timeEvents.get(timeA));
                groupA.removeAll((Collection)timeEvents.get(timeB));
                eventB3 = groupA.iterator();
                while (eventB3.hasNext()) {
                    EventMention event = (EventMention)eventB3.next();
                    this.createRelation(jCas, (IdentifiedAnnotation)timeB, (IdentifiedAnnotation)event, "CONTAINS", 1.0);
                }
                HashSet groupB = new HashSet();
                groupB.addAll((Collection)timeEvents.get(timeB));
                groupB.removeAll((Collection)timeEvents.get(timeA));
                for (EventMention event : groupB) {
                    this.createRelation(jCas, (IdentifiedAnnotation)timeA, (IdentifiedAnnotation)event, "CONTAINS", 1.0);
                }
            }
        }
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory, double confidence) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.setConfidence(confidence);
        relation.addToIndexes();
    }
}

