/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.tools;

import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class TRTablePane
extends JPanel {
    private static final long serialVersionUID = 3390510006593843456L;
    private final String[] t_columns = new String[]{"ID", "Form", "POS", "Head ID", "Deprel"};
    private JTable j_table;
    private DEPTree d_tree;
    private int t_height;

    public TRTablePane(TableModelListener listener, StringIntPair[] tags) {
        this.setLayout(new BorderLayout());
        this.j_table = new JTable();
        this.j_table.setModel(new DefaultTableModel(new Object[][]{{0, "", "", 0, ""}}, this.t_columns));
        this.j_table.getModel().addTableModelListener(listener);
        TableColumnModel columnModel = this.j_table.getColumnModel();
        for (StringIntPair tag : tags) {
            this.setColumnEditor(columnModel, tag.s, tag.i);
        }
        this.add((Component)this.j_table.getTableHeader(), "North");
        this.add((Component)this.j_table, "Center");
        this.t_height = this.j_table.getFontMetrics(this.j_table.getFont()).getHeight();
    }

    private void setColumnEditor(TableColumnModel model, String tagFile, int columnIndex) {
        BufferedReader fin = UTInput.createBufferedFileReader(tagFile);
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            while ((line = fin.readLine()) != null) {
                list.add(line.trim());
            }
            Collections.sort(list);
            Object[] tags = list.toArray();
            model.getColumn(columnIndex).setCellEditor(new DefaultCellEditor(new JComboBox<Object>(tags)));
            fin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init(DEPTree tree) {
        this.d_tree = tree;
        this.removeAll();
        this.add(tree);
        int rowCount = this.j_table.getModel().getRowCount();
        if (rowCount < 20) {
            rowCount = 20;
        }
        this.j_table.setPreferredSize(new Dimension(50, (rowCount + 3) * this.t_height));
        this.revalidate();
    }

    @Override
    public void removeAll() {
        DefaultTableModel model = (DefaultTableModel)this.j_table.getModel();
        int size = model.getRowCount();
        for (int i = size - 1; i >= 0; --i) {
            model.removeRow(i);
        }
    }

    public void add(DEPTree tree) {
        int size = tree.size();
        for (int i = 1; i < size; ++i) {
            this.add(tree.get(i));
        }
    }

    public void add(DEPNode node) {
        Object[] data = new Object[]{node.id, node.form, node.pos, node.getHead().id, node.getLabel()};
        DefaultTableModel model = (DefaultTableModel)this.j_table.getModel();
        model.addRow(data);
    }

    public void updateTree(int row, int column) {
        DEPNode node = this.d_tree.get(row + 1);
        Object value = this.j_table.getValueAt(row, column);
        if (column == 2) {
            node.pos = (String)value;
        } else if (column == 3) {
            int headId = Integer.parseInt((String)value);
            DEPNode head = this.d_tree.get(headId);
            if (head != null) {
                node.setHead(head);
            }
        } else if (column == 4) {
            node.setLabel((String)value);
        }
    }
}

