/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.reader;

import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.DEPReader;
import java.util.List;

public class SRLReader
extends DEPReader {
    private int i_sheads;

    public SRLReader(int iId, int iForm, int iLemma, int iPos, int iFeats, int iHeadId, int iDeprel, int iSheads) {
        super(iId, iForm, iLemma, iPos, iFeats, iHeadId, iDeprel);
        this.i_sheads = iSheads;
    }

    public void init(int iId, int iForm, int iLemma, int iPos, int iFeats, int iHeadId, int iDeprel, int iSheads) {
        super.init(iId, iForm, iLemma, iPos, iFeats, iHeadId, iDeprel);
        this.i_sheads = iSheads;
    }

    @Override
    public DEPTree next() {
        DEPTree tree = null;
        try {
            List<String[]> lines = this.readLines();
            if (lines == null) {
                return null;
            }
            tree = this.getDEPTree(lines);
            tree.initSHeads();
            if (this.i_sheads >= 0) {
                this.setSHeads(lines, tree);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tree;
    }

    private void setSHeads(List<String[]> lines, DEPTree tree) {
        int size = tree.size();
        tree.initSHeads();
        for (int i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            String heads = lines.get(i - 1)[this.i_sheads];
            if (heads.equals("_")) continue;
            for (String head : heads.split(";")) {
                String[] tmp = head.split(":");
                int headId = Integer.parseInt(tmp[0]);
                String label = tmp[1];
                node.addSHead(tree.get(headId), label);
            }
        }
    }

    @Override
    public String getType() {
        return "srl";
    }
}

