/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.reader;

import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.AbstractColumnReader;
import java.util.List;

public class DEPReader
extends AbstractColumnReader<DEPTree> {
    protected int i_id;
    protected int i_form;
    protected int i_lemma;
    protected int i_pos;
    protected int i_feats;
    protected int i_headId;
    protected int i_deprel;

    public DEPReader(int iId, int iForm, int iLemma, int iPos, int iFeats, int iHeadId, int iDeprel) {
        this.init(iId, iForm, iLemma, iPos, iFeats, iHeadId, iDeprel);
    }

    public void init(int iId, int iForm, int iLemma, int iPos, int iFeats, int iHeadId, int iDeprel) {
        this.i_id = iId;
        this.i_form = iForm;
        this.i_lemma = iLemma;
        this.i_pos = iPos;
        this.i_feats = iFeats;
        this.i_headId = iHeadId;
        this.i_deprel = iDeprel;
    }

    @Override
    public DEPTree next() {
        DEPTree tree = null;
        try {
            List<String[]> lines = this.readLines();
            if (lines == null) {
                return null;
            }
            tree = this.getDEPTree(lines);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tree;
    }

    protected DEPTree getDEPTree(List<String[]> lines) {
        int i;
        int size = lines.size();
        DEPTree tree = new DEPTree();
        for (i = 0; i < size; ++i) {
            tree.add(new DEPNode());
        }
        for (i = 0; i < size; ++i) {
            String[] tmp = lines.get(i);
            int id = Integer.parseInt(tmp[this.i_id]);
            String form = tmp[this.i_form];
            String lemma = tmp[this.i_lemma];
            String pos = tmp[this.i_pos];
            DEPFeat feats = new DEPFeat(tmp[this.i_feats]);
            DEPNode node = tree.get(id);
            node.init(id, form, lemma, pos, feats);
            if (this.i_headId < 0 || tmp[this.i_headId].equals("_")) continue;
            int headId = Integer.parseInt(tmp[this.i_headId]);
            String deprel = tmp[this.i_deprel];
            node.setHead(tree.get(headId), deprel);
        }
        return tree;
    }

    @Override
    public String getType() {
        return "dep";
    }
}

