/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.nlp;

import com.googlecode.clearnlp.component.dep.CDEPPassParser;
import com.googlecode.clearnlp.component.pos.CPOSTagger;
import com.googlecode.clearnlp.feature.xml.JointFtrXml;
import com.googlecode.clearnlp.nlp.NLPDevelop;
import com.googlecode.clearnlp.reader.JointReader;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTXml;
import java.io.FileInputStream;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;

public class NLPGenerate
extends NLPDevelop {
    @Option(name="-b", usage="the directory containing development files (required)", required=true, metaVar="<directory>")
    private int b_idx = -1;
    @Option(name="-e", usage="the directory containing development files (required)", required=true, metaVar="<directory>")
    private int e_idx = -1;
    @Option(name="-ie", usage="input file extension (default: .*)", required=false, metaVar="<regex>")
    private String s_inputExt = ".*";

    public NLPGenerate(String[] args) {
        this.initArgs(args);
        try {
            this.generate(this.s_configFile, this.s_featureFiles.split(":"), this.s_trainDir, this.s_inputExt, this.s_mode, this.b_idx, this.e_idx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generate(String configFile, String[] featureFiles, String trainDir, String inputExt, String mode, int bIdx, int eIdx) throws Exception {
        Element eConfig = UTXml.getDocumentElement(new FileInputStream(configFile));
        JointFtrXml[] xmls = this.getFeatureTemplates(featureFiles);
        String[] trainFiles = UTFile.getSortedFileListBySize(trainDir, inputExt, true);
        JointReader reader = this.getJointReader(UTXml.getFirstElementByTagName(eConfig, "reader"));
        this.b_generate = true;
        for (int i = bIdx; i < eIdx; ++i) {
            String[] devFiles = new String[]{trainFiles[i]};
            if (mode.equals("pos")) {
                this.developComponent(eConfig, reader, xmls, trainFiles, devFiles, new CPOSTagger(xmls, this.getLowerSimplifiedForms(reader, xmls[0], trainFiles, i)), mode, i);
                continue;
            }
            if (!mode.equals("dep")) continue;
            this.developComponentBoot(eConfig, reader, xmls, trainFiles, devFiles, new CDEPPassParser(xmls), mode, i);
        }
    }

    public static void main(String[] args) {
        new NLPGenerate(args);
    }
}

