/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.constituent.CTReader;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.io.FileExtFilter;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import java.io.File;

public class CompareCTTrees {
    public CompareCTTrees(String treeDir, String ext1, String ext2) {
        for (String filename1 : new File(treeDir).list(new FileExtFilter(ext1))) {
            CTTree tree1;
            filename1 = treeDir + File.separator + filename1;
            String filename2 = UTFile.replaceExtension(filename1, ext1, ext2);
            CTReader reader1 = new CTReader(UTInput.createBufferedFileReader(filename1));
            CTReader reader2 = new CTReader(UTInput.createBufferedFileReader(filename2));
            while ((tree1 = reader1.nextTree()) != null) {
                CTTree tree2 = reader2.nextTree();
                if (tree1.getTerminals().size() == tree2.getTerminals().size()) continue;
                System.out.println(filename2);
                System.out.println(tree1 + "\n" + tree2);
                return;
            }
        }
    }

    public static void main(String[] args) {
        new CompareCTTrees(args[0], args[1], args[2]);
    }
}

