/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.train;

import com.carrotsearch.hppc.IntArrayList;
import com.googlecode.clearnlp.classification.model.AbstractModel;
import com.googlecode.clearnlp.classification.vector.SparseFeatureVector;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.pair.IntIntPair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;

public abstract class AbstractTrainSpace {
    public static final byte VECTOR_SPARSE = 0;
    public static final byte VECTOR_STRING = 1;
    public static final String DELIM_COL = " ";
    protected AbstractModel m_model;
    protected boolean b_weight;
    protected IntArrayList a_ys;
    protected ArrayList<int[]> a_xs;
    protected ArrayList<double[]> a_vs;

    public AbstractTrainSpace(AbstractModel model, boolean hasWeight) {
        this.m_model = model;
        this.b_weight = hasWeight;
        this.a_ys = new IntArrayList();
        this.a_xs = new ArrayList();
        if (hasWeight) {
            this.a_vs = new ArrayList();
        }
    }

    public void readInstances(BufferedReader reader) {
        LineNumberReader fin = new LineNumberReader(reader);
        System.out.print("Reading: ");
        try {
            String line;
            while ((line = fin.readLine()) != null) {
                this.addInstance(line);
                if (fin.getLineNumber() % 10000 != 0) continue;
                System.out.print(".");
            }
            fin.close();
            System.out.println("\rReading: " + fin.getLineNumber());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract void addInstance(String var1);

    public abstract void build(boolean var1);

    public abstract void build();

    public IntArrayList getYs() {
        return this.a_ys;
    }

    public ArrayList<int[]> getXs() {
        return this.a_xs;
    }

    public ArrayList<double[]> getVs() {
        return this.a_vs;
    }

    public boolean hasWeight() {
        return this.b_weight;
    }

    public int getInstanceSize() {
        return this.a_ys.size();
    }

    public int getLabelSize() {
        return this.m_model.getLabelSize();
    }

    public int getFeatureSize() {
        return this.m_model.getFeatureSize();
    }

    public boolean isBinaryLabel() {
        return this.m_model.isBinaryLabel();
    }

    public AbstractModel getModel() {
        return this.m_model;
    }

    public static boolean hasWeight(byte vectorType, String filename) throws IOException {
        BufferedReader fin = UTInput.createBufferedFileReader(filename);
        String[] tmp = fin.readLine().split(DELIM_COL);
        int size = tmp.length;
        fin.close();
        for (int i = 1; i < size; ++i) {
            int idx1;
            String str = tmp[i];
            int idx0 = str.indexOf(":");
            if (idx0 == -1) {
                return false;
            }
            if (vectorType != 1 || (idx1 = str.lastIndexOf(":")) != -1 && idx0 != idx1) continue;
            return false;
        }
        return true;
    }

    public void printInstances(PrintStream fout) {
        int size = this.a_ys.size();
        for (int i = 0; i < size; ++i) {
            StringBuilder build = new StringBuilder();
            build.append(this.a_ys.get(i));
            int[] xs = this.a_xs.get(i);
            double[] vs = this.b_weight ? this.a_vs.get(i) : null;
            int len = xs.length;
            for (int j = 0; j < len; ++j) {
                build.append(DELIM_COL);
                build.append(xs[j]);
                if (!this.b_weight) continue;
                build.append(":");
                build.append(vs[j]);
            }
            fout.println(build.toString());
        }
    }

    public void printAccuracies() {
        int i;
        int lSize = this.m_model.getLabelSize();
        int tSize = this.a_ys.size();
        IntIntPair[] counts = new IntIntPair[lSize];
        double[] v = null;
        for (i = 0; i < lSize; ++i) {
            counts[i] = new IntIntPair(0, 0);
        }
        for (i = 0; i < tSize; ++i) {
            int y = this.a_ys.get(i);
            int[] x = this.a_xs.get(i);
            if (this.b_weight) {
                v = this.a_vs.get(i);
            }
            SparseFeatureVector vector = new SparseFeatureVector(this.b_weight);
            int len = x.length;
            for (int j = 0; j < len; ++j) {
                if (this.b_weight) {
                    vector.addFeature(x[j], v[j]);
                    continue;
                }
                vector.addFeature(x[j]);
            }
            if (this.m_model.getLabel(y).equals(this.m_model.predictBest((SparseFeatureVector)vector).label)) {
                ++counts[y].i1;
            }
            ++counts[y].i2;
        }
        for (i = 0; i < lSize; ++i) {
            IntIntPair c = counts[i];
            System.out.printf("%25s: %5.2f (%d/%d)\n", this.m_model.getLabel(i), 100.0 * (double)c.i1 / (double)c.i2, c.i1, c.i2);
        }
    }
}

