/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.beam;

import com.googlecode.clearnlp.beam.BeamNode;
import com.googlecode.clearnlp.classification.prediction.StringPrediction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BeamTree<T> {
    private List<BeamNode<T>> b_nodes;
    private int n_size;

    public BeamTree(int beamSize) {
        this.b_nodes = new ArrayList<BeamNode<T>>(beamSize);
        this.n_size = beamSize;
    }

    public BeamNode<T> getNode(int k) {
        return this.b_nodes.get(k);
    }

    public List<BeamNode<T>> getCurrNodes() {
        return this.b_nodes;
    }

    public void setBeam(List<List<StringPrediction>> predictions) {
        int i;
        ArrayList<BeamNode<T>> bNodes = new ArrayList<BeamNode<T>>();
        List<StringPrediction> cNodes = predictions.get(0);
        BeamNode<T> pNode = this.getPrevNode(0);
        int size = cNodes.size();
        if (size > this.n_size) {
            size = this.n_size;
        }
        for (i = 0; i < size; ++i) {
            bNodes.add(new BeamNode<T>(pNode, cNodes.get(i)));
        }
        size = predictions.size();
        for (i = 1; i < size; ++i) {
            cNodes = predictions.get(i);
            pNode = this.getPrevNode(i);
            double score = ((BeamNode)bNodes.get(bNodes.size() - 1)).getScore();
            for (StringPrediction p : cNodes) {
                if (p.score < score) break;
                bNodes.add(new BeamNode<T>(pNode, p));
            }
            Collections.sort(bNodes);
            if (bNodes.size() <= this.n_size) continue;
            bNodes.subList(this.n_size, bNodes.size()).clear();
        }
        this.b_nodes = bNodes;
    }

    public List<BeamNode<T>> getBestSequence() {
        List<BeamNode<T>> mSeq = this.b_nodes.get(0).getSequence();
        double mScore = this.getOverallScore(mSeq);
        int size = this.b_nodes.size();
        for (int i = 1; i < size; ++i) {
            List<BeamNode<T>> tSeq = this.b_nodes.get(i).getSequence();
            double tScore = this.getOverallScore(tSeq);
            if (!(tScore > mScore)) continue;
            mSeq = tSeq;
            mScore = tScore;
        }
        return mSeq;
    }

    protected double getOverallScore(List<BeamNode<T>> nodes) {
        double d = 0.0;
        for (BeamNode<T> node : nodes) {
            d += node.getScore();
        }
        return d;
    }

    private BeamNode<T> getPrevNode(int k) {
        return this.b_nodes.isEmpty() ? null : this.b_nodes.get(k);
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        for (BeamNode<T> node : this.b_nodes) {
            build.append("\n");
            build.append(this.toString(node));
        }
        return build.substring(1);
    }

    public String toString(BeamNode<T> node) {
        ArrayDeque<BeamNode> nodes = new ArrayDeque<BeamNode>();
        while (node != null) {
            nodes.add(node);
            node = node.getPrevNode();
        }
        StringBuilder build = new StringBuilder();
        while (!nodes.isEmpty()) {
            node = (BeamNode)nodes.pollLast();
            build.append(" -> ");
            build.append(node.getLabel() + ":" + node.getScore());
        }
        return build.substring(4);
    }
}

