/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.annotators;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SentenceSpan {
    public static String LF = "\n";
    public static String CR = "\r";
    public static String CRLF = "\r\n";
    private int start;
    private int end;
    private String text;
    private static final Pattern dotPattern = Pattern.compile("\\.");
    private static final Pattern nonWhiteSpacePattern = Pattern.compile("\\S");

    public SentenceSpan(int s, int e, String t) {
        this.start = s;
        this.end = e;
        this.text = t;
    }

    public void setStart(int in) {
        this.start = in;
    }

    public void setEnd(int in) {
        this.end = in;
    }

    public void setText(String in) {
        this.text = in;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getText() {
        return this.text;
    }

    public List<SentenceSpan> splitAtLineBreaksAndTrim(String separatorPattern) {
        ArrayList<SentenceSpan> subspans = new ArrayList<SentenceSpan>();
        if (!(separatorPattern.equals(LF) || separatorPattern.equals(CR) || separatorPattern.equals(CRLF))) {
            int len = separatorPattern.length();
            System.err.println("Invalid line break: " + len + " characters long.");
            System.err.print("        line break character values: ");
            for (int i = 0; i < len; ++i) {
                System.err.print((Object)separatorPattern.charAt(i));
                System.err.print(" ");
            }
            System.err.println();
            subspans.add(this);
            return subspans;
        }
        String coveredText = this.text.substring(0, this.end - this.start);
        String trimmedText = coveredText.trim();
        int trimmedLen = trimmedText.length();
        if (trimmedLen == 0) {
            return subspans;
        }
        int trimmedStart = this.start;
        int positionOfNonWhiteSpace = 0;
        if (trimmedLen != coveredText.length()) {
            positionOfNonWhiteSpace = coveredText.indexOf(trimmedText);
            trimmedStart = this.start + positionOfNonWhiteSpace;
        }
        String[] spans = new String[]{trimmedText};
        int position = trimmedStart;
        for (String s : spans) {
            String t = s.trim();
            positionOfNonWhiteSpace = t.length() > 0 ? s.indexOf(t.charAt(0)) : 0;
            subspans.add(new SentenceSpan(position += positionOfNonWhiteSpace, position + t.length(), t));
            position += s.length() - positionOfNonWhiteSpace + separatorPattern.length();
        }
        return subspans;
    }

    public String toString() {
        String s = "(" + this.start + ", " + this.end + ") " + this.text;
        return s;
    }

    public List<SentenceSpan> splitAtPeriodAndTrim(Pattern acronymPattern, Pattern periodPattern, Pattern splitPattern) {
        ArrayList<SentenceSpan> subspans = new ArrayList<SentenceSpan>();
        if (acronymPattern == null && periodPattern == null) {
            subspans.add(this);
        } else {
            String coveredText = this.text.substring(0, this.end - this.start);
            String trimmedText = coveredText.trim();
            int trimmedLen = trimmedText.length();
            if (trimmedLen == 0) {
                return subspans;
            }
            int trimmedStart = this.start;
            int positionOfNonWhiteSpace = 0;
            if (trimmedLen != coveredText.length()) {
                positionOfNonWhiteSpace = coveredText.indexOf(trimmedText);
                trimmedStart = this.start + positionOfNonWhiteSpace;
            }
            Matcher dotMatcher = dotPattern.matcher(trimmedText);
            int position = trimmedStart;
            int currentStartPos = 0;
            while (dotMatcher.find()) {
                Matcher nwsMatcher;
                boolean ok = true;
                if (acronymPattern != null && dotMatcher.start() > 0) {
                    String precedingText = trimmedText.substring(currentStartPos, dotMatcher.start());
                    boolean bl = ok = !acronymPattern.matcher(precedingText).find();
                }
                if (ok && periodPattern != null && dotMatcher.end() < trimmedText.length()) {
                    String followingText = trimmedText.substring(dotMatcher.end());
                    ok = periodPattern.matcher(followingText).find();
                }
                if (!ok) continue;
                String t = trimmedText.substring(currentStartPos, dotMatcher.end());
                subspans.add(new SentenceSpan(position + currentStartPos, position + currentStartPos + t.length(), t));
                if ((currentStartPos += t.length()) >= trimmedText.length() || !(nwsMatcher = nonWhiteSpacePattern.matcher(trimmedText.substring(currentStartPos))).find()) continue;
                currentStartPos += nwsMatcher.start();
            }
            if (currentStartPos < trimmedText.length()) {
                String t = trimmedText.substring(currentStartPos);
                subspans.add(new SentenceSpan(position + currentStartPos, position + currentStartPos + t.length(), t));
            }
        }
        return this.splitSubspans(subspans, splitPattern);
    }

    public List<SentenceSpan> splitSubspans(List<SentenceSpan> subspans, Pattern splitPattern) {
        ArrayList<SentenceSpan> splitSubspans = new ArrayList<SentenceSpan>();
        if (splitPattern == null) {
            splitSubspans.addAll(subspans);
        } else {
            for (SentenceSpan span : subspans) {
                String t;
                String trimmedText = span.getText();
                boolean bSplit = false;
                Matcher matcher = splitPattern.matcher(trimmedText);
                int position = span.getStart();
                int currentStartPos = 0;
                while (matcher.find()) {
                    bSplit = true;
                    if (matcher.start() <= currentStartPos) continue;
                    t = trimmedText.substring(currentStartPos, matcher.start());
                    splitSubspans.add(new SentenceSpan(position + currentStartPos, position + currentStartPos + t.length(), t));
                    currentStartPos += t.length();
                }
                if (bSplit) {
                    if (currentStartPos >= trimmedText.length()) continue;
                    t = trimmedText.substring(currentStartPos);
                    splitSubspans.add(new SentenceSpan(position + currentStartPos, position + currentStartPos + t.length(), t));
                    continue;
                }
                splitSubspans.add(span);
            }
        }
        return splitSubspans;
    }
}

