/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.annotators;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.ytex.uima.ApplicationContextHolder;
import org.apache.ctakes.ytex.uima.dao.SegmentRegexDao;
import org.apache.ctakes.ytex.uima.model.SegmentRegex;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class SegmentRegexAnnotator
extends JCasAnnotator_ImplBase {
    private static final Log log = LogFactory.getLog(SegmentRegexAnnotator.class);
    private SegmentRegexDao segmentRegexDao;
    private Map<SegmentRegex, Pattern> regexMap = new HashMap<SegmentRegex, Pattern>();
    private String defaultSegmentId = "DEFAULT";

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        this.segmentRegexDao = (SegmentRegexDao)ApplicationContextHolder.getApplicationContext().getBean("segmentRegexDao");
        List<SegmentRegex> regexList = this.segmentRegexDao.getSegmentRegexs();
        this.initRegexMap(regexList);
        String defaultSegmentId = (String)aContext.getConfigParameterValue("SegmentID");
        if (!Strings.isNullOrEmpty((String)defaultSegmentId)) {
            this.defaultSegmentId = defaultSegmentId;
        }
    }

    protected void initRegexMap(List<SegmentRegex> regexList) {
        for (SegmentRegex regex : regexList) {
            if (log.isDebugEnabled()) {
                log.debug((Object)regex);
            }
            Pattern pat = Pattern.compile(regex.getRegex());
            this.regexMap.put(regex, pat);
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String strDocText = aJCas.getDocumentText();
        if (strDocText == null) {
            return;
        }
        ArrayList<Segment> segmentsAdded = new ArrayList<Segment>();
        for (Map.Entry<SegmentRegex, Pattern> entry : this.regexMap.entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("applying regex:" + entry.getKey().getRegex()));
            }
            Matcher matcher = entry.getValue().matcher(strDocText);
            while (matcher.find()) {
                Segment seg = new Segment(aJCas);
                if (entry.getKey().isLimitToRegex() && matcher.groupCount() == 1) {
                    seg.setBegin(matcher.start(1));
                    seg.setEnd(matcher.end(1));
                } else {
                    seg.setBegin(matcher.start());
                    if (entry.getKey().isLimitToRegex()) {
                        seg.setEnd(matcher.end());
                    }
                }
                seg.setId(entry.getKey().getSegmentID());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found match: id=" + seg.getId() + ", begin=" + seg.getBegin()));
                }
                segmentsAdded.add(seg);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("segmentsAdded: " + segmentsAdded.size()));
        }
        if (segmentsAdded.size() > 0) {
            Collections.sort(segmentsAdded, new Comparator<Segment>(){

                @Override
                public int compare(Segment o1, Segment o2) {
                    return o1.getBegin() < o2.getBegin() ? -1 : (o1.getBegin() > o2.getBegin() ? 1 : 0);
                }
            });
            for (int i = 0; i < segmentsAdded.size(); ++i) {
                Segment segNext;
                Segment seg = (Segment)((Object)segmentsAdded.get(i));
                Segment segment = segNext = i + 1 < segmentsAdded.size() ? (Segment)((Object)segmentsAdded.get(i + 1)) : null;
                if (seg.getEnd() <= 0) {
                    if (segNext != null) {
                        seg.setEnd(segNext.getBegin() - 1);
                    } else {
                        seg.setEnd(strDocText.length());
                    }
                } else if (segNext != null && segNext.getBegin() < seg.getEnd()) {
                    seg.setEnd(segNext.getBegin() - 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding Segment: segment id=" + seg.getId() + ", begin=" + seg.getBegin() + ", end=" + seg.getEnd()));
                }
                seg.addToIndexes();
            }
        }
        int end = 0;
        for (Segment seg : segmentsAdded) {
            if (seg.getBegin() - 1 > end) {
                this.addGapSegment(aJCas, end, seg.getBegin() - 1);
            }
            end = seg.getEnd();
        }
        if (end < strDocText.length()) {
            this.addGapSegment(aJCas, end, strDocText.length());
        }
    }

    private void addGapSegment(JCas aJCas, int begin, int end) {
        Segment segGap = new Segment(aJCas);
        segGap.setBegin(begin);
        segGap.setEnd(end);
        segGap.addToIndexes();
        segGap.setId(this.defaultSegmentId);
    }
}

