/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import uk.co.flamingpenguin.jewel.JewelException;
import uk.co.flamingpenguin.jewel.cli.HelpValidationErrorImpl;
import uk.co.flamingpenguin.jewel.cli.OptionSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.UnexpectedOptionSpecification;

@Deprecated
public class ArgumentValidationException
extends JewelException {
    private static final long serialVersionUID = -4781861924515211053L;
    private static final ResourceBundle m_messages = ResourceBundle.getBundle("uk.co.flamingpenguin.jewel.cli.Messages", Locale.getDefault());
    private final ArrayList<ValidationError> m_validationErrors;
    private final String m_message;

    public ArgumentValidationException(ValidationError validationError) {
        this(Arrays.asList(validationError));
    }

    public ArgumentValidationException(List<ValidationError> validationErrors) {
        this.m_validationErrors = new ArrayList<ValidationError>(validationErrors);
        StringBuilder message = new StringBuilder();
        String separator = "";
        for (ValidationError error : validationErrors) {
            message.append(separator).append(error.toString());
            separator = System.getProperty("line.separator");
        }
        this.m_message = message.toString();
    }

    public ArrayList<ValidationError> getValidationErrors() {
        return this.m_validationErrors;
    }

    @Override
    public String getMessage() {
        return this.m_message;
    }

    static ValidationError createUnexpectedOptionError(String name) {
        return new ValidationErrorImpl(ValidationError.ErrorType.UnexpectedOption, new UnexpectedOptionSpecification(name));
    }

    static ValidationError createAdditionalValuesError(OptionSpecification optionSpecification) {
        return new ValidationErrorImpl(ValidationError.ErrorType.AdditionalValue, optionSpecification);
    }

    static ValidationError createMissingValueError(OptionSpecification optionSpecification) {
        return new ValidationErrorImpl(ValidationError.ErrorType.MissingValue, optionSpecification);
    }

    static ValidationError createUnexpectedValueError(OptionSpecification optionSpecification) {
        return new ValidationErrorImpl(ValidationError.ErrorType.UnexpectedValue, optionSpecification);
    }

    static ValidationError createUnexpectedTrailingValue() {
        return new ValidationErrorImpl(ValidationError.ErrorType.UnexpectedTrailingValue, null);
    }

    static ValidationError createMissingOptionError(OptionSpecification optionSpecification) {
        return new ValidationErrorImpl(ValidationError.ErrorType.MissingOption, optionSpecification);
    }

    static ValidationError createInvalidValueForType(OptionSpecification optionSpecification, String message) {
        return new ValidationErrorImpl(ValidationError.ErrorType.InvalidValueForType, optionSpecification, message);
    }

    static ValidationError createUnableToConstructType(OptionSpecification optionSpecification, String message) {
        return new ValidationErrorImpl(ValidationError.ErrorType.UnableToConstructType, optionSpecification, message);
    }

    static ValidationError createPatternMismatch(OptionSpecification optionSpecification, String message) {
        return new ValidationErrorImpl(ValidationError.ErrorType.PatternMismatch, optionSpecification, message);
    }

    static ValidationError createhelpRequested(OptionsSpecification<?> specification) {
        return new HelpValidationErrorImpl(specification);
    }

    private static class ValidationErrorImpl
    implements ValidationError {
        private final ValidationError.ErrorType m_errorType;
        private final OptionSpecification m_specification;
        private final String m_message;

        public ValidationErrorImpl(ValidationError.ErrorType errorType, OptionSpecification specification) {
            this(errorType, specification, "");
        }

        public ValidationErrorImpl(ValidationError.ErrorType errorType, OptionSpecification specification, String message) {
            this.m_errorType = errorType;
            this.m_specification = specification;
            this.m_message = message;
        }

        @Override
        public ValidationError.ErrorType getErrorType() {
            return this.m_errorType;
        }

        private OptionSpecification getSpecification() {
            return this.m_specification;
        }

        public String toString() {
            return String.format("%s: %s", this.getErrorType().getDescription(this), this.getSpecification());
        }

        @Override
        public String getMessage() {
            return this.m_message;
        }
    }

    public static interface ValidationError {
        public String getMessage();

        public ErrorType getErrorType();

        public static enum ErrorType {
            UnexpectedOption{

                @Override
                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.UnexpectedOption");
                }
            }
            ,
            MissingValue{

                @Override
                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.MissingValue");
                }
            }
            ,
            MisplacedOption{

                @Override
                public String getDescription(ValidationError error) {
                    return String.format(m_messages.getString("validationError.MisplacedOption"), error.getMessage());
                }
            }
            ,
            UnexpectedValue{

                @Override
                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.UnexpectedValue");
                }
            }
            ,
            AdditionalValue{

                @Override
                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.AdditionalValue");
                }
            }
            ,
            MissingOption{

                @Override
                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.MissingOption");
                }
            }
            ,
            InvalidValueForType{

                @Override
                public String getDescription(ValidationError error) {
                    return String.format(m_messages.getString("validationError.InvalidValueForType"), error.getMessage());
                }
            }
            ,
            UnableToConstructType{

                @Override
                public String getDescription(ValidationError error) {
                    return String.format(m_messages.getString("validationError.UnableToConstructType"), error.getMessage());
                }
            }
            ,
            PatternMismatch{

                @Override
                public String getDescription(ValidationError error) {
                    return String.format(m_messages.getString("validationError.PatternMismatch"), error.getMessage());
                }
            }
            ,
            HelpRequested{

                @Override
                public String getDescription(ValidationError error) {
                    return error.getMessage();
                }
            }
            ,
            UnexpectedTrailingValue{

                @Override
                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.UnexpectedTrailingValue");
                }
            };


            public abstract String getDescription(ValidationError var1);
        }
    }
}

