/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.strtable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.dictionary.lookup.strtable.StringTableRow;

public final class StringTable {
    private final Map<String, Map<String, Set<StringTableRow>>> iv_nameMap = new HashMap<String, Map<String, Set<StringTableRow>>>();

    public StringTable(String[] indexedFieldNames) {
        for (String fieldName : indexedFieldNames) {
            this.iv_nameMap.put(fieldName, new HashMap());
        }
    }

    public void addRow(StringTableRow strTableRow) {
        for (Map.Entry<String, Map<String, Set<StringTableRow>>> stringMapEntry : this.iv_nameMap.entrySet()) {
            String indexedFieldValue;
            Map<String, Set<StringTableRow>> valueMap = stringMapEntry.getValue();
            Set<StringTableRow> rowSet = valueMap.get(indexedFieldValue = strTableRow.getFieldValue(stringMapEntry.getKey()));
            if (rowSet == null) {
                rowSet = new HashSet<StringTableRow>();
            }
            rowSet.add(strTableRow);
            valueMap.put(indexedFieldValue, rowSet);
        }
    }

    public StringTableRow[] getRows(String indexedFieldName, String fieldVal) {
        Map<String, Set<StringTableRow>> valueMap = this.iv_nameMap.get(indexedFieldName);
        Set<StringTableRow> rowSet = valueMap.get(fieldVal);
        if (rowSet != null) {
            return rowSet.toArray(new StringTableRow[rowSet.size()]);
        }
        return new StringTableRow[0];
    }

    public StringTableRow[] getAllRows() {
        HashSet<StringTableRow> allRows = new HashSet<StringTableRow>();
        for (Map<String, Set<StringTableRow>> valueMap : this.iv_nameMap.values()) {
            for (Set<StringTableRow> rowSet : valueMap.values()) {
                if (rowSet.isEmpty()) continue;
                allRows.addAll(rowSet);
            }
        }
        return allRows.toArray(new StringTableRow[allRows.size()]);
    }
}

