/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.lucene;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.ctakes.dictionary.lookup.AbstractBaseDictionary;
import org.apache.ctakes.dictionary.lookup.DictionaryException;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.lucene.LuceneDocumentMetaDataHitImpl;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Version;

public class LuceneDictionaryImpl
extends AbstractBaseDictionary {
    private final IndexSearcher iv_searcher;
    private final String iv_lookupFieldName;
    private int iv_maxHits;
    private Logger iv_logger = Logger.getLogger((String)this.getClass().getName());

    public LuceneDictionaryImpl(IndexSearcher searcher, String lookupFieldName) {
        this(searcher, lookupFieldName, Integer.MAX_VALUE);
    }

    public LuceneDictionaryImpl(IndexSearcher searcher, String lookupFieldName, int maxListHits) {
        this.iv_searcher = searcher;
        this.iv_lookupFieldName = lookupFieldName;
        this.iv_maxHits = maxListHits;
    }

    @Override
    public Collection<MetaDataHit> getEntries(String text) throws DictionaryException {
        HashSet<MetaDataHit> metaDataHitSet = new HashSet<MetaDataHit>();
        try {
            ScoreDoc[] hits;
            TermQuery q = null;
            TopDocs topDoc = null;
            if (text.indexOf(45) == -1) {
                q = new TermQuery(new Term(this.iv_lookupFieldName, text));
                topDoc = this.iv_searcher.search((Query)q, this.iv_maxHits);
            } else {
                QueryParser query = new QueryParser(Version.LUCENE_40, this.iv_lookupFieldName, (Analyzer)new KeywordAnalyzer());
                try {
                    String escaped = QueryParserBase.escape((String)text.replace('-', ' '));
                    topDoc = this.iv_searcher.search(query.parse(escaped), this.iv_maxHits);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (topDoc == null) {
                this.iv_logger.warn((Object)(this.getClass().getName() + " getEntries(..) topDoc is null, returning empty collection"));
                return Collections.emptySet();
            }
            if (this.iv_maxHits == 0) {
                this.iv_maxHits = Integer.MAX_VALUE;
                this.iv_logger.warn((Object)"iv_maxHits was 0, using Integer.MAX_VALUE instead");
            }
            if ((hits = topDoc.scoreDocs).length == this.iv_maxHits) {
                this.iv_logger.warn((Object)("'iv_maxHits' equals the list length returned by the lucene query (" + hits.length + ")."));
                this.iv_logger.warn((Object)("You may want to consider setting a higher value, since there may be more entries not being returned in the event greater than " + this.iv_maxHits + " exist."));
            }
            for (ScoreDoc scoreDoc : hits) {
                Document luceneDoc = this.iv_searcher.doc(scoreDoc.doc);
                LuceneDocumentMetaDataHitImpl mdh = new LuceneDocumentMetaDataHitImpl(luceneDoc);
                metaDataHitSet.add(mdh);
            }
            return metaDataHitSet;
        }
        catch (IOException ioe) {
            throw new DictionaryException(ioe);
        }
    }

    @Override
    public boolean contains(String text) throws DictionaryException {
        try {
            TermQuery q = new TermQuery(new Term(this.iv_lookupFieldName, text));
            TopDocs topDoc = this.iv_searcher.search((Query)q, this.iv_maxHits);
            ScoreDoc[] hits = topDoc.scoreDocs;
            return hits != null && hits.length > 0;
        }
        catch (IOException ioe) {
            throw new DictionaryException(ioe);
        }
    }
}

