/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class PermutationUtil {
    public static List<List<Integer>> getPermutationList(int maxLevel) {
        ArrayList<List<Integer>> permList = new ArrayList<List<Integer>>();
        for (int levelIdx = maxLevel; levelIdx >= 0; --levelIdx) {
            ArrayList<Integer> baseNumList = new ArrayList<Integer>();
            for (int j = 1; j <= levelIdx; ++j) {
                baseNumList.add(j);
            }
            ArrayList<List<Integer>> numListCol = new ArrayList<List<Integer>>();
            if (levelIdx != maxLevel) {
                numListCol.addAll(PermutationUtil.getNumLists(maxLevel, baseNumList));
            } else {
                numListCol.add(baseNumList);
            }
            for (List list : numListCol) {
                Collection<List<Integer>> pCol = PermutationUtil.getLinearPermutations(list);
                for (List<Integer> permutation : pCol) {
                    permList.add(permutation);
                }
            }
            if (levelIdx != 0) continue;
            permList.add(new ArrayList());
        }
        return permList;
    }

    private static Collection<List<Integer>> getNumLists(int maxLevel, List<Integer> baseNumList) {
        ArrayList<List<Integer>> numListCol = new ArrayList<List<Integer>>();
        PermutationUtil.buildPermutations(maxLevel, baseNumList, numListCol, new ArrayList<Integer>(), 0);
        PermutationUtil.filterNonIncreasingLists(numListCol);
        return numListCol;
    }

    private static void filterNonIncreasingLists(Collection<List<Integer>> numListCol) {
        HashSet<List<Integer>> removalSet = new HashSet<List<Integer>>();
        for (List<Integer> numList : numListCol) {
            Integer largestNum = null;
            for (Integer num : numList) {
                if (largestNum == null) {
                    largestNum = num;
                    continue;
                }
                int comparison = largestNum.compareTo(num);
                if (comparison == 1) {
                    removalSet.add(numList);
                    continue;
                }
                largestNum = num;
            }
        }
        numListCol.removeAll(removalSet);
    }

    private static void buildPermutations(int maxLevel, List<Integer> baseNumList, Collection<List<Integer>> numListCol, List<Integer> residualList, int residualCount) {
        if (residualCount > baseNumList.size()) {
            return;
        }
        if (residualCount == baseNumList.size()) {
            numListCol.add(new ArrayList<Integer>(residualList));
            return;
        }
        int num = baseNumList.get(residualCount);
        ++residualCount;
        for (int i = num; i <= maxLevel; ++i) {
            ArrayList<Integer> tempList = new ArrayList<Integer>(residualList);
            if (tempList.contains(i)) continue;
            tempList.add(i);
            PermutationUtil.buildPermutations(maxLevel, baseNumList, numListCol, tempList, residualCount);
        }
    }

    public static Collection<List<Integer>> getLinearPermutations(List<Integer> numList) {
        ArrayList<List<Integer>> permutations = new ArrayList<List<Integer>>();
        PermutationUtil.getLinearPermutations(permutations, new ArrayList<Integer>(), numList);
        return permutations;
    }

    private static void getLinearPermutations(Collection<List<Integer>> permutations, List<Integer> plusList, List<Integer> numList) {
        for (Integer num : numList) {
            ArrayList<Integer> subList = new ArrayList<Integer>(numList);
            subList.remove(num);
            plusList.add(num);
            if (!subList.isEmpty()) {
                PermutationUtil.getLinearPermutations(permutations, plusList, subList);
            } else {
                ArrayList<Integer> permutation = new ArrayList<Integer>(plusList);
                permutations.add(permutation);
            }
            plusList.remove(num);
        }
    }
}

