/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.dictionary.lookup.DictionaryEngine;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.algorithms.LookupAlgorithm;
import org.apache.ctakes.dictionary.lookup.algorithms.PermutationUtil;
import org.apache.ctakes.dictionary.lookup.phrasebuilder.PhraseBuilder;
import org.apache.ctakes.dictionary.lookup.vo.LookupAnnotation;
import org.apache.ctakes.dictionary.lookup.vo.LookupHit;
import org.apache.ctakes.dictionary.lookup.vo.LookupToken;
import org.apache.log4j.Logger;

public class FirstTokenPermutationImpl
implements LookupAlgorithm {
    private final Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    public static final String CTX_KEY_WINDOW_ANNOTATIONS = "WINDOW_ANNOTATIONS";
    public static final String LT_KEY_USE_FOR_LOOKUP = "USE_FOR_LOOKUP";
    private final DictionaryEngine iv_firstTokenDictEngine;
    private final PhraseBuilder iv_phrBuilder;
    private final int iv_maxPermutationLevel;
    private final Map<Integer, List<List<Integer>>> iv_permCacheMap;
    private String[] iv_textMetaFieldNames;

    public FirstTokenPermutationImpl(DictionaryEngine firstTokenDictEngine, PhraseBuilder phraseBuilder, String[] textMetaFieldNames, int maxPermutationLevel) {
        this.iv_firstTokenDictEngine = firstTokenDictEngine;
        this.iv_phrBuilder = phraseBuilder;
        this.iv_textMetaFieldNames = textMetaFieldNames;
        this.iv_maxPermutationLevel = maxPermutationLevel;
        this.iv_permCacheMap = new HashMap<Integer, List<List<Integer>>>(maxPermutationLevel);
        for (int i = 0; i <= maxPermutationLevel; ++i) {
            List<List<Integer>> permList = PermutationUtil.getPermutationList(i);
            this.iv_permCacheMap.put(i, permList);
        }
    }

    @Override
    public Collection<LookupHit> lookup(List<LookupToken> lookupTokenList, Map<String, List<LookupAnnotation>> contextMap) throws Exception {
        List<LookupAnnotation> windowAnnotations = this.getWindowAnnotations(contextMap);
        boolean useWindowAnnots = !windowAnnotations.isEmpty();
        Map<Integer, List<LookupAnnotation>> wStartOffsetMap = FirstTokenPermutationImpl.getMultipleStartOffsetMap(windowAnnotations);
        Map<Integer, List<LookupAnnotation>> wEndOffsetMap = FirstTokenPermutationImpl.getMultipleEndOffsetMap(windowAnnotations);
        Map<LookupToken, Integer> ltListIndexMap = FirstTokenPermutationImpl.getListIndexMap(lookupTokenList);
        Map<Integer, List<LookupToken>> ltStartOffsetMap = FirstTokenPermutationImpl.getMultipleStartOffsetMap(lookupTokenList);
        Map<Integer, List<LookupToken>> ltEndOffsetMap = FirstTokenPermutationImpl.getMultipleEndOffsetMap(lookupTokenList);
        ArrayList<LookupHit> lookupHits = new ArrayList<LookupHit>();
        for (int currentIndex = 0; currentIndex < lookupTokenList.size(); ++currentIndex) {
            List<LookupToken> endLookupTokenList;
            LookupAnnotation windowAnnotation;
            Collection<MetaDataHit> firstTokenHits;
            LookupToken lookupToken = lookupTokenList.get(currentIndex);
            String useForLookupString = lookupToken.getStringAttribute(LT_KEY_USE_FOR_LOOKUP);
            boolean useForLookup = Boolean.valueOf(useForLookupString);
            if (!useForLookup || (firstTokenHits = this.getFirstTokenHits(lookupToken)) == null || firstTokenHits.isEmpty()) continue;
            int wEndOffset = -1;
            if (useWindowAnnots && (windowAnnotation = this.getLargestWindowAnnotation(currentIndex, lookupToken, ltStartOffsetMap, ltEndOffsetMap, ltListIndexMap, wStartOffsetMap, wEndOffsetMap)) != null) {
                wEndOffset = windowAnnotation.getEndOffset();
            }
            if (wEndOffset == -1) {
                this.iv_logger.debug((Object)"Window size set to max perm level.");
                wEndOffset = this.getFixedWindowEndOffset(currentIndex, lookupToken, lookupTokenList);
            }
            if ((endLookupTokenList = FirstTokenPermutationImpl.getLookupTokenList(wEndOffset, ltEndOffsetMap, false)).isEmpty()) {
                this.iv_logger.debug((Object)("Invalid window:" + currentIndex + "," + wEndOffset));
                continue;
            }
            LookupToken endLookupToken = endLookupTokenList.get(endLookupTokenList.size() - 1);
            int startTokenIndex = currentIndex;
            int endTokenIndex = ltListIndexMap.get(endLookupToken);
            List<LookupToken> wLookupTokenList = lookupTokenList.subList(startTokenIndex, endTokenIndex + 1);
            Collection<LookupHit> lhCol = this.getLookupHits(firstTokenHits, wLookupTokenList, currentIndex - startTokenIndex);
            lookupHits.addAll(lhCol);
        }
        return lookupHits;
    }

    private Map<String, Set<MetaDataHit>> getNamedMetaDataHits(Collection<MetaDataHit> firstTokenHits) {
        HashMap<String, Set<MetaDataHit>> namedMetaDataHits = new HashMap<String, Set<MetaDataHit>>();
        for (MetaDataHit firstTokenHit : firstTokenHits) {
            for (String name : this.iv_textMetaFieldNames) {
                String text = firstTokenHit.getMetaFieldValue(name);
                if (text != null) {
                    HashSet<MetaDataHit> mdhSet = (HashSet<MetaDataHit>)namedMetaDataHits.get(text = text.toLowerCase());
                    if (mdhSet == null) {
                        mdhSet = new HashSet<MetaDataHit>();
                    }
                    mdhSet.add(firstTokenHit);
                    namedMetaDataHits.put(text, mdhSet);
                    continue;
                }
                if (!this.iv_logger.isDebugEnabled()) continue;
                this.iv_logger.debug((Object)("MetaField " + name + " contains no data."));
            }
        }
        return namedMetaDataHits;
    }

    private Collection<LookupHit> getLookupHits(Collection<MetaDataHit> firstTokenHits, List<LookupToken> wLookupTokenList, int firstTokenIndex) throws Exception {
        if (wLookupTokenList.size() - 1 > this.iv_maxPermutationLevel) {
            this.iv_logger.debug((Object)"Beyond permutation cache size.");
            return Collections.emptyList();
        }
        Map<String, Set<MetaDataHit>> namedMetaDataHits = this.getNamedMetaDataHits(firstTokenHits);
        ArrayList<LookupHit> lookupHits = new ArrayList<LookupHit>();
        LookupToken firstWordLookupToken = wLookupTokenList.get(firstTokenIndex);
        int firstWordStartOffset = firstWordLookupToken.getStartOffset();
        int firstWordEndOffset = firstWordLookupToken.getEndOffset();
        List<LookupToken> singleTokenList = Arrays.asList(firstWordLookupToken);
        String[] firstWordPhrases = this.iv_phrBuilder.getPhrases(singleTokenList);
        for (int i = 0; i < firstWordPhrases.length; ++i) {
            firstWordPhrases[i] = firstWordPhrases[i].toLowerCase();
        }
        int permutationIndex = wLookupTokenList.size();
        if (firstTokenIndex < wLookupTokenList.size() && permutationIndex > 0) {
            --permutationIndex;
        }
        List<List<Integer>> permutationList = this.iv_permCacheMap.get(permutationIndex);
        for (List<Integer> permutations : permutationList) {
            String[] lookupTokenPhrases;
            Object lastToken;
            Object firstToken;
            List permutationsSorted = (List)((ArrayList)permutations).clone();
            Collections.sort(permutationsSorted);
            int startOffset = firstWordStartOffset;
            int endOffset = firstWordEndOffset;
            if (!permutationsSorted.isEmpty()) {
                int lastIdx;
                int firstIdx = (Integer)permutationsSorted.get(0);
                if (firstIdx <= firstTokenIndex) {
                    --firstIdx;
                }
                if ((firstToken = wLookupTokenList.get(firstIdx)).getStartOffset() < firstWordStartOffset) {
                    startOffset = firstToken.getStartOffset();
                }
                if ((lastIdx = ((Integer)permutationsSorted.get(permutationsSorted.size() - 1)).intValue()) <= firstTokenIndex) {
                    --lastIdx;
                }
                if ((lastToken = wLookupTokenList.get(lastIdx)).getEndOffset() > firstWordEndOffset) {
                    endOffset = lastToken.getEndOffset();
                }
            }
            ArrayList<LookupToken> tempLookupTokens = new ArrayList<LookupToken>();
            firstToken = permutations.iterator();
            while (firstToken.hasNext()) {
                Integer idx = firstToken.next();
                if (idx <= firstTokenIndex) {
                    lastToken = idx;
                    Integer n = idx = Integer.valueOf(idx - 1);
                }
                LookupToken lookupToken = wLookupTokenList.get(idx);
                tempLookupTokens.add(lookupToken);
            }
            for (String lookupTokenPhrase : lookupTokenPhrases = this.iv_phrBuilder.getPhrases(tempLookupTokens)) {
                lookupTokenPhrase = lookupTokenPhrase.toLowerCase();
                for (String firstWordPhrase : firstWordPhrases) {
                    StringBuilder phraseSB = new StringBuilder();
                    phraseSB.append(firstWordPhrase).append(' ').append(lookupTokenPhrase);
                    String fullPhrase = phraseSB.toString().trim();
                    Set<MetaDataHit> mdhSet = namedMetaDataHits.get(fullPhrase);
                    if (mdhSet == null) continue;
                    for (MetaDataHit mdh : mdhSet) {
                        LookupHit lh = new LookupHit(mdh, startOffset, endOffset);
                        lookupHits.add(lh);
                    }
                }
            }
        }
        return lookupHits;
    }

    private List<LookupAnnotation> getWindowAnnotations(Map<String, List<LookupAnnotation>> contextMap) {
        List<LookupAnnotation> list = contextMap.get(CTX_KEY_WINDOW_ANNOTATIONS);
        if (list == null || list.isEmpty()) {
            this.iv_logger.debug((Object)"No context window annotations.");
            return Collections.emptyList();
        }
        return list;
    }

    private int getNumberOfListTokens(Map<Integer, List<LookupToken>> ltStartOffsetMap, Map<Integer, List<LookupToken>> ltEndOffsetMap, Map<LookupToken, Integer> ltListIndexMap, int startOffset, int endOffset) {
        List<LookupToken> startLookupTokenList = FirstTokenPermutationImpl.getLookupTokenList(startOffset, ltStartOffsetMap, true);
        List<LookupToken> endLookupTokenList = FirstTokenPermutationImpl.getLookupTokenList(endOffset, ltEndOffsetMap, false);
        if (startLookupTokenList.isEmpty() || endLookupTokenList.isEmpty()) {
            this.iv_logger.debug((Object)("Invalid window:" + startOffset + "," + endOffset));
            return -1;
        }
        LookupToken startLookupToken = startLookupTokenList.get(0);
        Integer startIdx = ltListIndexMap.get(startLookupToken);
        LookupToken endLookupToken = endLookupTokenList.get(endLookupTokenList.size() - 1);
        Integer endIdx = ltListIndexMap.get(endLookupToken);
        return endIdx - startIdx + 1;
    }

    private static List<LookupToken> getLookupTokenList(int offset, Map<Integer, List<LookupToken>> ltOffsetMap, boolean traverseRight) {
        List<LookupToken> lookupTokenList = ltOffsetMap.get(offset);
        if (lookupTokenList != null) {
            return lookupTokenList;
        }
        int offsetWindow = 10;
        if (traverseRight) {
            int max = offset + 10;
            for (int i = offset; i <= max; ++i) {
                lookupTokenList = ltOffsetMap.get(i);
                if (lookupTokenList == null) continue;
                return lookupTokenList;
            }
        } else {
            int min = offset - 10;
            for (int i = offset; i >= min; --i) {
                lookupTokenList = ltOffsetMap.get(i);
                if (lookupTokenList == null) continue;
                return lookupTokenList;
            }
        }
        return Collections.emptyList();
    }

    private LookupAnnotation getLargestWindowAnnotation(int tokenIdx, LookupToken lt, Map<Integer, List<LookupToken>> ltStartOffsetMap, Map<Integer, List<LookupToken>> ltEndOffsetMap, Map<LookupToken, Integer> ltListIndexMap, Map<Integer, List<LookupAnnotation>> wStartOffsetMap, Map<Integer, List<LookupAnnotation>> wEndOffsetMap) {
        HashSet startCandidateSet = new HashSet();
        HashSet endCandidateSet = new HashSet();
        for (Map.Entry<Integer, List<LookupAnnotation>> entry : wStartOffsetMap.entrySet()) {
            Integer startOffset = entry.getKey();
            if (startOffset > lt.getStartOffset()) continue;
            startCandidateSet.addAll(entry.getValue());
        }
        for (Map.Entry<Integer, List<LookupAnnotation>> entry : wEndOffsetMap.entrySet()) {
            Integer endOffset = entry.getKey();
            if (endOffset < lt.getEndOffset()) continue;
            endCandidateSet.addAll(entry.getValue());
        }
        startCandidateSet.retainAll(endCandidateSet);
        LookupAnnotation largestWindowAnnot = null;
        for (LookupAnnotation tempLookupAnnot : startCandidateSet) {
            if (largestWindowAnnot != null && tempLookupAnnot.getLength() <= largestWindowAnnot.getLength()) continue;
            int ltCount = this.getNumberOfListTokens(ltStartOffsetMap, ltEndOffsetMap, ltListIndexMap, tempLookupAnnot.getStartOffset(), tempLookupAnnot.getEndOffset());
            if (ltCount <= this.iv_maxPermutationLevel && ltCount > 0) {
                largestWindowAnnot = tempLookupAnnot;
                continue;
            }
            if (!this.iv_logger.isDebugEnabled()) continue;
            this.iv_logger.debug((Object)("Window size of " + ltCount + " exceeds the max permutation level of " + this.iv_maxPermutationLevel + "."));
        }
        return largestWindowAnnot;
    }

    private int getFixedWindowEndOffset(int tokenIdx, LookupToken lt, List<LookupToken> ltList) {
        int count = Math.min(tokenIdx + this.iv_maxPermutationLevel, ltList.size());
        if (count <= 0) {
            return 0;
        }
        for (int i = count - 1; i >= 0; --i) {
            LookupToken tempLookupToken = ltList.get(i);
            if (tempLookupToken == null) continue;
            return tempLookupToken.getEndOffset();
        }
        return 0;
    }

    private static Map<LookupToken, Integer> getListIndexMap(List<LookupToken> list) {
        HashMap<LookupToken, Integer> m = new HashMap<LookupToken, Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            m.put(list.get(i), i);
        }
        return m;
    }

    private static <T extends LookupAnnotation> Map<Integer, T> getSingleStartOffsetMap(List<T> lookupAnnotList) {
        HashMap<Integer, LookupAnnotation> m = new HashMap<Integer, LookupAnnotation>();
        for (LookupAnnotation lookupAnnotation : lookupAnnotList) {
            Integer key = lookupAnnotation.getStartOffset();
            m.put(key, lookupAnnotation);
        }
        return m;
    }

    private static <T extends LookupAnnotation> Map<Integer, List<T>> getMultipleStartOffsetMap(List<T> lookupAnnotList) {
        HashMap<Integer, List<T>> m = new HashMap<Integer, List<T>>();
        for (LookupAnnotation lookupAnnotation : lookupAnnotList) {
            Integer key = lookupAnnotation.getStartOffset();
            ArrayList<LookupAnnotation> list = (ArrayList<LookupAnnotation>)m.get(key);
            if (list == null) {
                list = new ArrayList<LookupAnnotation>();
            }
            list.add(lookupAnnotation);
            m.put(key, list);
        }
        return m;
    }

    private static <T extends LookupAnnotation> Map<Integer, T> getSingleEndOffsetMap(List<T> lookupAnnotList) {
        HashMap<Integer, LookupAnnotation> m = new HashMap<Integer, LookupAnnotation>();
        for (LookupAnnotation lookupAnnotation : lookupAnnotList) {
            Integer key = lookupAnnotation.getEndOffset();
            m.put(key, lookupAnnotation);
        }
        return m;
    }

    private static <T extends LookupAnnotation> Map<Integer, List<T>> getMultipleEndOffsetMap(List<T> lookupAnnotList) {
        HashMap<Integer, List<T>> m = new HashMap<Integer, List<T>>();
        for (LookupAnnotation lookupAnnotation : lookupAnnotList) {
            Integer key = lookupAnnotation.getEndOffset();
            ArrayList<LookupAnnotation> list = (ArrayList<LookupAnnotation>)m.get(key);
            if (list == null) {
                list = new ArrayList<LookupAnnotation>();
            }
            list.add(lookupAnnotation);
            m.put(key, list);
        }
        return m;
    }

    private Collection<MetaDataHit> getFirstTokenHits(LookupToken firstLookupToken) throws Exception {
        List<LookupToken> singleTokenList = Arrays.asList(firstLookupToken);
        String[] phrases = this.iv_phrBuilder.getPhrases(singleTokenList);
        ArrayList<MetaDataHit> metaDataHits = new ArrayList<MetaDataHit>();
        for (String phrase : phrases) {
            Collection<MetaDataHit> phraseMetaDataHits = this.iv_firstTokenDictEngine.metaLookup(phrase);
            if (phraseMetaDataHits.isEmpty()) continue;
            metaDataHits.addAll(phraseMetaDataHits);
        }
        return metaDataHits;
    }
}

