/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.ae.LookupConsumer;
import org.apache.ctakes.dictionary.lookup.ae.LookupInitializer;
import org.apache.ctakes.dictionary.lookup.ae.LookupParseUtilities;
import org.apache.ctakes.dictionary.lookup.ae.LookupSpec;
import org.apache.ctakes.dictionary.lookup.ae.UmlsToSnomedDbConsumerImpl;
import org.apache.ctakes.dictionary.lookup.algorithms.LookupAlgorithm;
import org.apache.ctakes.dictionary.lookup.vo.LookupAnnotation;
import org.apache.ctakes.dictionary.lookup.vo.LookupHit;
import org.apache.ctakes.dictionary.lookup.vo.LookupToken;
import org.apache.ctakes.dictionary.lookup.vo.LookupTokenComparator;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.jdom.JDOMException;

public class ThreadedDictionaryLookupAnnotator
extends JCasAnnotator_ImplBase {
    private final Logger _logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private Set<LookupSpec> _lookupSpecSet = new HashSet<LookupSpec>();
    private Map<LookupHitKey, Set<MetaDataHit>> _duplicateDataMap = new ConcurrentHashMap<LookupHitKey, Set<MetaDataHit>>();

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this.configInit(uimaContext);
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        for (LookupSpec value : this._lookupSpecSet) {
            LookupSpec ls;
            LookupConsumer lookupConsumer;
            if (!(value instanceof LookupSpec) || (lookupConsumer = (ls = value).getLookupConsumer()) == null || !(lookupConsumer instanceof UmlsToSnomedDbConsumerImpl)) continue;
            ((UmlsToSnomedDbConsumerImpl)lookupConsumer).close();
        }
        super.collectionProcessComplete();
    }

    private void configInit(UimaContext uimaContext) throws ResourceInitializationException {
        try {
            FileResource fResrc = (FileResource)uimaContext.getResourceObject("LookupDescriptor");
            File descFile = fResrc.getFile();
            this._logger.info((Object)("Parsing descriptor: " + descFile.getAbsolutePath()));
            this._lookupSpecSet = LookupParseUtilities.parseDescriptor(descFile, uimaContext);
        }
        catch (ResourceAccessException raE) {
            throw new ResourceInitializationException((Throwable)raE);
        }
        catch (JDOMException jdomE) {
            throw new ResourceInitializationException((Throwable)jdomE);
        }
        catch (IOException ioE) {
            throw new ResourceInitializationException((Throwable)ioE);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(final JCas jcas) throws AnalysisEngineProcessException {
        this._logger.info((Object)"process(JCas)");
        this._duplicateDataMap.clear();
        int specCount = 0;
        for (LookupSpec value : this._lookupSpecSet) {
            if (!(value instanceof LookupSpec)) continue;
            ++specCount;
        }
        int procCount = Runtime.getRuntime().availableProcessors();
        int threadCount = Math.min(specCount, procCount);
        ExecutorService fixedThreadService = Executors.newFixedThreadPool(threadCount);
        ExecutorCompletionService<LookupDataStore> completionService = new ExecutorCompletionService<LookupDataStore>(fixedThreadService);
        for (LookupSpec value : this._lookupSpecSet) {
            if (!(value instanceof LookupSpec)) continue;
            final LookupSpec ls = value;
            completionService.submit(new Callable<LookupDataStore>(){

                @Override
                public LookupDataStore call() {
                    return ThreadedDictionaryLookupAnnotator.this.getLookupData(jcas, ls);
                }
            });
        }
        try {
            for (int i = 0; i < specCount; ++i) {
                Future future = completionService.take();
                LookupDataStore lookupDataStore = (LookupDataStore)future.get();
                LookupConsumer lookupConsumer = lookupDataStore.__lookupSpec.getLookupConsumer();
                lookupConsumer.consumeHits(jcas, lookupDataStore.__allHits.iterator());
            }
        }
        catch (InterruptedException intE) {
            throw new AnalysisEngineProcessException((Throwable)intE);
        }
        catch (ExecutionException exE) {
            throw new AnalysisEngineProcessException((Throwable)exE);
        }
        try {
            fixedThreadService.shutdown();
        }
        catch (SecurityException sE) {
            this._logger.debug((Object)("Can ignore: " + sE.getMessage()));
        }
    }

    private LookupDataStore getLookupData(JCas jcas, LookupSpec lookupSpec) {
        Iterator<Annotation> windowItr;
        LookupInitializer lookupInitializer = lookupSpec.getLookupInitializer();
        try {
            windowItr = lookupInitializer.getLookupWindowIterator(jcas);
        }
        catch (AnnotatorInitializationException aiE) {
            return new LookupDataStore(lookupSpec, new ArrayList(0));
        }
        LookupAlgorithm algorithm = lookupSpec.getLookupAlgorithm();
        ArrayList<LookupHit> allHits = new ArrayList<LookupHit>();
        while (windowItr.hasNext()) {
            Annotation window = windowItr.next();
            try {
                List<LookupToken> lookupTokensInWindow = lookupInitializer.getSortedLookupTokens(jcas, window);
                Map<String, List<LookupAnnotation>> contextMap = lookupInitializer.getContextMap(jcas, window.getBegin(), window.getEnd());
                allHits.addAll(this.performLookup(algorithm, lookupTokensInWindow, contextMap));
            }
            catch (AnnotatorInitializationException annotatorInitializationException) {}
        }
        return new LookupDataStore(lookupSpec, allHits);
    }

    private Collection<LookupHit> performLookup(LookupAlgorithm algorithm, List<LookupToken> lookupTokenList, Map<String, List<LookupAnnotation>> contextMap) {
        Collection<LookupHit> lookupHits;
        Collections.sort(lookupTokenList, LookupTokenComparator.getInstance());
        try {
            lookupHits = algorithm.lookup(lookupTokenList, contextMap);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        return this.filterHitDups(lookupHits);
    }

    private Collection<LookupHit> filterHitDups(Collection<LookupHit> lookupHitCol) {
        ArrayList<LookupHit> uniqueHits = new ArrayList<LookupHit>();
        for (LookupHit lookupHit : lookupHitCol) {
            if (this.isDuplicate(lookupHit)) continue;
            uniqueHits.add(lookupHit);
        }
        return uniqueHits;
    }

    private boolean isDuplicate(LookupHit lookupHit) {
        MetaDataHit metaDataHit = lookupHit.getDictMetaDataHit();
        LookupHitKey lookupHitKey = new LookupHitKey(lookupHit);
        Set<MetaDataHit> mdhDuplicateSet = this._duplicateDataMap.get(lookupHitKey);
        if (mdhDuplicateSet != null && mdhDuplicateSet.contains(metaDataHit)) {
            return true;
        }
        mdhDuplicateSet = new HashSet<MetaDataHit>();
        mdhDuplicateSet.add(metaDataHit);
        this._duplicateDataMap.put(lookupHitKey, mdhDuplicateSet);
        return false;
    }

    private static class LookupHitKey {
        private final int __start;
        private final int __end;
        private final int __hashCode;

        private LookupHitKey(LookupHit lookupHit) {
            this.__start = lookupHit.getStartOffset();
            this.__end = lookupHit.getEndOffset();
            this.__hashCode = 1000 * this.__end + this.__start;
        }

        public int hashCode() {
            return this.__hashCode;
        }

        public boolean equals(Object object) {
            return object instanceof LookupHitKey && this.__start == ((LookupHitKey)object).__start && this.__end == ((LookupHitKey)object).__end;
        }
    }

    private static class LookupDataStore {
        private final LookupSpec __lookupSpec;
        private final Collection<LookupHit> __allHits;

        private LookupDataStore(LookupSpec lookupSpec, Collection<LookupHit> allHits) {
            this.__lookupSpec = lookupSpec;
            this.__allHits = allHits;
        }
    }
}

