/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.ae.LookupInitializer;
import org.apache.ctakes.dictionary.lookup.ae.LookupParseUtilities;
import org.apache.ctakes.dictionary.lookup.ae.LookupSpec;
import org.apache.ctakes.dictionary.lookup.algorithms.LookupAlgorithm;
import org.apache.ctakes.dictionary.lookup.vo.LookupAnnotation;
import org.apache.ctakes.dictionary.lookup.vo.LookupHit;
import org.apache.ctakes.dictionary.lookup.vo.LookupToken;
import org.apache.ctakes.dictionary.lookup.vo.LookupTokenComparator;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Dictionary Lookup (Old)", description="Annotates clinically-relevant terms.  This is an older, slower dictionary lookup implementation.", dependencies={PipeBitInfo.TypeProduct.CHUNK, PipeBitInfo.TypeProduct.BASE_TOKEN}, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class DictionaryLookupAnnotator
extends JCasAnnotator_ImplBase {
    private Logger iv_logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private UimaContext iv_context;
    private Set<LookupSpec> iv_lookupSpecSet = new HashSet<LookupSpec>();
    private Map<String, Set<MetaDataHit>> iv_dupMap = new HashMap<String, Set<MetaDataHit>>();

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.iv_context = aContext;
        this.configInit();
    }

    private void configInit() throws ResourceInitializationException {
        try {
            FileResource fResrc = (FileResource)this.iv_context.getResourceObject("LookupDescriptor");
            File descFile = fResrc.getFile();
            this.iv_logger.info((Object)("Parsing descriptor: " + descFile.getAbsolutePath()));
            this.iv_lookupSpecSet = LookupParseUtilities.parseDescriptor(descFile, this.iv_context);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.iv_logger.info((Object)"process(JCas)");
        this.iv_dupMap.clear();
        try {
            for (LookupSpec ls : this.iv_lookupSpecSet) {
                LookupInitializer lInit = ls.getLookupInitializer();
                Iterator<Annotation> windowItr = lInit.getLookupWindowIterator(jcas);
                while (windowItr.hasNext()) {
                    Annotation window = windowItr.next();
                    List<LookupToken> lookupTokensInWindow = lInit.getSortedLookupTokens(jcas, window);
                    Map<String, List<LookupAnnotation>> ctxMap = lInit.getContextMap(jcas, window.getBegin(), window.getEnd());
                    this.performLookup(jcas, ls, lookupTokensInWindow, ctxMap);
                }
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private void performLookup(JCas jcas, LookupSpec ls, List<LookupToken> lookupTokenList, Map<String, List<LookupAnnotation>> ctxMap) throws Exception {
        Collections.sort(lookupTokenList, LookupTokenComparator.getInstance());
        Collection<LookupHit> lookupHitCol = null;
        LookupAlgorithm la = ls.getLookupAlgorithm();
        lookupHitCol = la.lookup(lookupTokenList, ctxMap);
        Collection<LookupHit> uniqueHitCol = this.filterHitDups(lookupHitCol);
        ls.getLookupConsumer().consumeHits(jcas, uniqueHitCol.iterator());
    }

    private Collection<LookupHit> filterHitDups(Collection<LookupHit> lookupHitCol) {
        ArrayList<LookupHit> l = new ArrayList<LookupHit>();
        for (LookupHit lh : lookupHitCol) {
            if (this.isDuplicate(lh)) continue;
            l.add(lh);
        }
        return l;
    }

    private boolean isDuplicate(LookupHit lh) {
        MetaDataHit mdh = lh.getDictMetaDataHit();
        String offsetKey = DictionaryLookupAnnotator.getOffsetKey(lh);
        Set<MetaDataHit> mdhDuplicateSet = this.iv_dupMap.get(offsetKey);
        if (mdhDuplicateSet != null) {
            for (MetaDataHit otherMdh : mdhDuplicateSet) {
                if (!mdh.equals(otherMdh)) continue;
                return true;
            }
        } else {
            mdhDuplicateSet = new HashSet<MetaDataHit>();
        }
        mdhDuplicateSet.add(mdh);
        this.iv_dupMap.put(offsetKey, mdhDuplicateSet);
        return false;
    }

    private static List<LookupToken> constrainToWindow(Annotation window, Iterator<LookupToken> lookupTokenItr) throws Exception {
        ArrayList<LookupToken> ltObjectList = new ArrayList<LookupToken>();
        while (lookupTokenItr.hasNext()) {
            LookupToken lt = lookupTokenItr.next();
            if (lt.getStartOffset() < window.getBegin() || lt.getEndOffset() > window.getEnd()) continue;
            ltObjectList.add(lt);
        }
        return ltObjectList;
    }

    private static String getOffsetKey(LookupHit lh) {
        StringBuffer sb = new StringBuffer();
        sb.append(lh.getStartOffset());
        sb.append(',');
        sb.append(lh.getEndOffset());
        return sb.toString();
    }
}

