/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

public class HeadBodyListener
implements SystemEventListener {
    private static Logger log = Logger.getLogger("org.icefaces.impl.event.HeadBodyListener");

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext fc = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = fc.getViewRoot();
        Map viewMap = viewRoot.getViewMap();
        UIOutput comp = (UIOutput)((PostAddToViewEvent)event).getComponent();
        String rendererType = comp.getRendererType();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "post add to view for : " + comp + ", " + rendererType);
        }
        if (rendererType == null) {
            return;
        }
        if (!viewMap.containsKey("org.icefaces.headDetected") && rendererType.equals("javax.faces.Head")) {
            viewMap.put("org.icefaces.headDetected", "org.icefaces.headDetected");
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "head detected");
            }
        }
        if (!viewMap.containsKey("org.icefaces.bodyDetected") && rendererType.equals("javax.faces.Body")) {
            viewMap.put("org.icefaces.bodyDetected", "org.icefaces.bodyDetected");
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "body detected");
            }
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIOutput;
    }
}

