/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.context;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.icefaces.impl.context.DOMPartialRenderCallback;
import org.icefaces.impl.context.DOMResponseWriter;
import org.icefaces.impl.util.DOMUtils;
import org.icefaces.util.EnvUtils;
import org.icefaces.util.FocusController;
import org.icefaces.util.JavaScriptRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMPartialViewContext
extends PartialViewContextWrapper {
    private static final String JAVAX_FACES_VIEW_HEAD = "javax.faces.ViewHead";
    private static final String JAVAX_FACES_VIEW_BODY = "javax.faces.ViewBody";
    private static final Logger log = Logger.getLogger(DOMPartialViewContext.class.getName());
    private PartialViewContext wrapped;
    protected FacesContext facesContext;
    private PartialResponseWriter partialWriter;
    private Boolean isAjaxRequest;
    private static final Runnable NOOP = new Runnable(){

        public void run() {
        }
    };

    public DOMPartialViewContext(PartialViewContext partialViewContext, FacesContext facesContext) {
        this.wrapped = partialViewContext;
        this.facesContext = facesContext;
    }

    public PartialViewContext getWrapped() {
        return this.wrapped;
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.wrapped.setPartialRequest(isPartialRequest);
    }

    public boolean isAjaxRequest() {
        if (this.isAjaxRequest != null) {
            return this.isAjaxRequest;
        }
        return this.wrapped.isAjaxRequest();
    }

    public void setAjaxRequest(boolean isAjaxRequest) {
        this.isAjaxRequest = isAjaxRequest;
    }

    public void processPartial(PhaseId phaseId) {
        if (!EnvUtils.isICEfacesView(this.facesContext)) {
            this.wrapped.processPartial(phaseId);
            return;
        }
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            try {
                PartialResponseWriter partialWriter = this.getPartialResponseWriter();
                ExternalContext ec = this.facesContext.getExternalContext();
                Writer outputWriter = this.getResponseOutputWriter();
                ec.setResponseContentType("text/xml");
                ec.addResponseHeader("Cache-Control", "no-cache");
                DOMResponseWriter writer = new DOMResponseWriter(outputWriter, ec.getRequestCharacterEncoding(), ec.getRequestContentType());
                this.facesContext.setResponseWriter((ResponseWriter)writer);
                Document oldDOM = writer.getOldDocument();
                this.applyBrowserChanges(ec.getRequestParameterValuesMap(), oldDOM);
                UIViewRoot viewRoot = this.facesContext.getViewRoot();
                Node[] diffs = new Node[]{};
                Document newDOM = null;
                writer.startDocument();
                if (this.isRenderAll()) {
                    for (UIComponent kid : viewRoot.getChildren()) {
                        kid.encodeAll(this.facesContext);
                    }
                    writer.endDocument();
                    newDOM = writer.getOldDocument();
                    if (oldDOM != null && newDOM != null) {
                        diffs = DOMPartialViewContext.domDiff(oldDOM, newDOM);
                    }
                } else {
                    writer.startSubtreeRendering();
                    Collection renderIds = this.getRenderIds();
                    if (renderIds != null && !renderIds.isEmpty()) {
                        diffs = this.renderSubtrees(viewRoot, renderIds);
                    }
                    writer.endDocument();
                    newDOM = writer.getOldDocument();
                }
                partialWriter.startDocument();
                if (null == oldDOM && this.isRenderAll()) {
                    partialWriter.startUpdate("javax.faces.ViewRoot");
                    this.writeXMLPreamble(outputWriter);
                    DOMUtils.printNodeCDATA(newDOM.getDocumentElement(), outputWriter);
                    partialWriter.endUpdate();
                    this.renderState();
                    this.renderExtensions();
                } else {
                    for (int i = 0; i < diffs.length; ++i) {
                        Element element = (Element)diffs[i];
                        if ("head".equalsIgnoreCase(element.getTagName())) continue;
                        partialWriter.startUpdate(DOMPartialViewContext.getUpdateId(element));
                        DOMUtils.printNodeCDATA(element, outputWriter);
                        partialWriter.endUpdate();
                    }
                    this.renderState();
                    this.renderExtensions();
                }
                partialWriter.endDocument();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw ex;
            }
        } else {
            super.processPartial(phaseId);
        }
    }

    protected Writer getResponseOutputWriter() throws IOException {
        return this.facesContext.getExternalContext().getResponseOutputWriter();
    }

    private void writeXMLPreamble(Writer writer) throws IOException {
        FacesContext fc = FacesContext.getCurrentInstance();
        UIViewRoot root = fc.getViewRoot();
        Object val = root.getAttributes().get("<?xml");
        if (val != null) {
            writer.write(val.toString());
        }
        if ((val = root.getAttributes().get("<!DOCTYPE")) != null) {
            writer.write(val.toString());
        }
    }

    private static String getUpdateId(Element element) {
        if ("head".equalsIgnoreCase(element.getTagName())) {
            return JAVAX_FACES_VIEW_HEAD;
        }
        if ("body".equalsIgnoreCase(element.getTagName())) {
            return JAVAX_FACES_VIEW_BODY;
        }
        return element.getAttribute("id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node[] domDiff(Document oldDOM, Document newDOM) {
        Runnable oldHeadRollback = DOMPartialViewContext.setHeadID(oldDOM);
        Runnable oldBodyRollback = DOMPartialViewContext.setBodyID(oldDOM);
        Runnable newHeadRollback = DOMPartialViewContext.setHeadID(newDOM);
        Runnable newBodyRollback = DOMPartialViewContext.setBodyID(newDOM);
        try {
            Node[] nodeArray = DOMUtils.domDiff(oldDOM, newDOM);
            return nodeArray;
        }
        finally {
            oldHeadRollback.run();
            oldBodyRollback.run();
            newHeadRollback.run();
            newBodyRollback.run();
        }
    }

    private static Runnable setBodyID(Document document) {
        Element body;
        NodeList nodes = document.getElementsByTagName("body");
        if (nodes.getLength() > 0 && !(body = (Element)nodes.item(0)).hasAttribute("id")) {
            body.setAttribute("id", JAVAX_FACES_VIEW_BODY);
            return new Runnable(){

                public void run() {
                    body.removeAttribute("id");
                }
            };
        }
        return NOOP;
    }

    private static Runnable setHeadID(Document document) {
        Element head;
        NodeList nodes = document.getElementsByTagName("head");
        if (nodes.getLength() > 0 && !(head = (Element)nodes.item(0)).hasAttribute("id")) {
            head.setAttribute("id", JAVAX_FACES_VIEW_HEAD);
            return new Runnable(){

                public void run() {
                    head.removeAttribute("id");
                }
            };
        }
        return NOOP;
    }

    private Node[] renderSubtrees(UIViewRoot viewRoot, Collection<String> renderIds) {
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)this.facesContext, renderIds, hints);
        DOMPartialRenderCallback renderCallback = new DOMPartialRenderCallback(this.facesContext);
        viewRoot.visitTree(visitContext, (VisitCallback)renderCallback);
        return renderCallback.getDiffs();
    }

    private void applyBrowserChanges(Map parameters, Document document) {
        String[] values;
        if (null == document) {
            return;
        }
        NodeList inputElements = document.getElementsByTagName("input");
        int inputElementsLength = inputElements.getLength();
        for (int i = 0; i < inputElementsLength; ++i) {
            String currValue;
            String type;
            Element inputElement = (Element)inputElements.item(i);
            String id = inputElement.getAttribute("id");
            if ("".equals(id)) continue;
            if (parameters.containsKey(id)) {
                String value = ((String[])parameters.get(id))[0];
                if ("".equals(value)) {
                    inputElement.setAttribute("value", "");
                    continue;
                }
                if (inputElement.hasAttribute("value")) {
                    inputElement.setAttribute("value", value);
                    continue;
                }
                if (!inputElement.getAttribute("type").equals("checkbox")) continue;
                inputElement.setAttribute("checked", "checked");
                continue;
            }
            String name = inputElement.getAttribute("name");
            if ("".equals(name) || !parameters.containsKey(name) || (type = inputElement.getAttribute("type")) == null || !type.equals("checkbox") && !type.equals("radio") || "".equals(currValue = inputElement.getAttribute("value"))) continue;
            boolean found = false;
            values = (String[])parameters.get(name);
            if (values != null) {
                for (int v = 0; v < values.length; ++v) {
                    if (!currValue.equals(values[v])) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                if (type.equals("checkbox")) {
                    inputElement.setAttribute("checked", "true");
                    continue;
                }
                if (!type.equals("radio")) continue;
                inputElement.setAttribute("checked", "checked");
                continue;
            }
            inputElement.removeAttribute("checked");
        }
        NodeList textareaElements = document.getElementsByTagName("textarea");
        int textareaElementsLength = textareaElements.getLength();
        for (int i = 0; i < textareaElementsLength; ++i) {
            Element textareaElement = (Element)textareaElements.item(i);
            String id = textareaElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id)) continue;
            String value = ((String[])parameters.get(id))[0];
            Node firstChild = textareaElement.getFirstChild();
            if (null != firstChild) {
                firstChild.setNodeValue(value);
                continue;
            }
            if (value == null || value.length() <= 0) continue;
            textareaElement.appendChild(document.createTextNode(value));
        }
        NodeList selectElements = document.getElementsByTagName("select");
        int selectElementsLength = selectElements.getLength();
        for (int i = 0; i < selectElementsLength; ++i) {
            Element selectElement = (Element)selectElements.item(i);
            String id = selectElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id)) continue;
            values = Arrays.asList((String[])parameters.get(id));
            NodeList optionElements = selectElement.getElementsByTagName("option");
            int optionElementsLength = optionElements.getLength();
            for (int j = 0; j < optionElementsLength; ++j) {
                Element optionElement = (Element)optionElements.item(j);
                if (values.contains(optionElement.getAttribute("value"))) {
                    optionElement.setAttribute("selected", "selected");
                    continue;
                }
                optionElement.removeAttribute("selected");
            }
        }
    }

    private void renderState() throws IOException {
        PartialResponseWriter writer = this.getPartialResponseWriter();
        writer.startUpdate("javax.faces.ViewState");
        String state = this.facesContext.getApplication().getStateManager().getViewState(this.facesContext);
        writer.write(state);
        writer.endUpdate();
    }

    protected void renderExtensions() {
        this.manageFocus();
        this.runScripts();
    }

    private void manageFocus() {
        boolean focusNotYetSet;
        String focusId = FocusController.getReceivedFocus(this.facesContext);
        boolean bl = focusNotYetSet = !FocusController.isFocusSet(this.facesContext);
        if (focusNotYetSet && focusId != null) {
            FocusController.setFocus(this.facesContext, focusId);
        }
        if (FocusController.isFocusSet(this.facesContext)) {
            JavaScriptRunner.runScript(this.facesContext, "ice.applyFocus('" + FocusController.getFocus(this.facesContext) + "');");
        }
    }

    private void runScripts() {
        String scripts = JavaScriptRunner.collateScripts(this.facesContext);
        if (scripts.length() > 0) {
            try {
                PartialResponseWriter partialWriter = this.getPartialResponseWriter();
                partialWriter.startEval();
                partialWriter.write(scripts);
                partialWriter.endEval();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

