/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.icefaces.impl.context.DOMResponseWriter;
import org.icefaces.impl.util.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DOMPartialRenderCallback
implements VisitCallback {
    private static Logger log = Logger.getLogger(DOMPartialRenderCallback.class.getName());
    private FacesContext facesContext;
    private ArrayList<Node> diffs;
    private boolean exception;

    public DOMPartialRenderCallback(FacesContext facesContext) {
        this.facesContext = facesContext;
        this.diffs = new ArrayList();
        this.exception = false;
    }

    public VisitResult visit(VisitContext visitContext, UIComponent component) {
        block4: {
            String clientId = component.getClientId(this.facesContext);
            DOMResponseWriter domWriter = (DOMResponseWriter)this.facesContext.getResponseWriter();
            Node oldSubtree = domWriter.seekSubtree(clientId);
            try {
                component.encodeAll(this.facesContext);
                Element newSubtree = domWriter.getDocument().getElementById(clientId);
                if (null == oldSubtree) {
                    this.diffs.add(newSubtree);
                } else {
                    this.diffs.addAll(Arrays.asList(DOMUtils.nodeDiff(oldSubtree, newSubtree)));
                }
            }
            catch (Exception e) {
                this.exception = true;
                if (!log.isLoggable(Level.SEVERE)) break block4;
                log.severe("Subtree rendering failed for " + component.getClass() + " " + clientId + e.toString());
            }
        }
        return VisitResult.REJECT;
    }

    public Node[] getDiffs() {
        return this.diffs.toArray(new Node[0]);
    }

    public boolean didFail() {
        return this.exception;
    }
}

